/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.jetty;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.helpers.ssl.SSLTrustManager;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TLSServerConnectorBuilder {
    public static final String DEFAULT_CERTIFICATE_FILE = "/etc/grid-security/hostcert.pem";
    public static final String DEFAULT_CERTIFICATE_KEY_FILE = "/etc/grid-security/hostcert.pem";
    private int port;
    private String certificateFile = "/etc/grid-security/hostcert.pem";
    private String certificateKeyFile = "/etc/grid-security/hostcert.pem";
    private char[] certicateKeyPassword = null;
    private final X509CertChainValidatorExt certificateValidator;
    private boolean tlsNeedClientAuth = false;
    private boolean tlsWantClientAuth = true;
    private String[] includeProtocols;
    private String[] excludeProtocols;
    private String[] includeCipherSuites;
    private String[] excludeCipherSuites;
    private HttpConfiguration httpConfiguration;
    private KeyManager keyManager;
    private final Server server;

    public static TLSServerConnectorBuilder instance(Server s, X509CertChainValidatorExt certificateValidator) {
        return new TLSServerConnectorBuilder(s, certificateValidator);
    }

    private TLSServerConnectorBuilder(Server s, X509CertChainValidatorExt certificateValidator) {
        if (s == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        if (certificateValidator == null) {
            throw new IllegalArgumentException("certificateValidator cannot be null");
        }
        this.server = s;
        this.certificateValidator = certificateValidator;
    }

    private void credentialsSanityChecks() {
        this.checkFileExistsAndIsReadable(new File(this.certificateFile), "Error accessing certificate file");
        this.checkFileExistsAndIsReadable(new File(this.certificateKeyFile), "Error accessing certificate key file");
    }

    private void loadCredentials() {
        this.credentialsSanityChecks();
        PEMCredential serviceCredentials = null;
        try {
            serviceCredentials = new PEMCredential(this.certificateKeyFile, this.certificateFile, this.certicateKeyPassword);
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw new RuntimeException("Error setting up service credentials", e);
        }
        this.keyManager = serviceCredentials.getKeyManager();
    }

    private void configureContextFactory(SslContextFactory contextFactory) {
        if (this.excludeProtocols != null) {
            contextFactory.setExcludeProtocols(this.excludeProtocols);
        }
        if (this.includeProtocols != null) {
            contextFactory.setIncludeProtocols(this.includeProtocols);
        }
        if (this.excludeCipherSuites != null) {
            contextFactory.setExcludeCipherSuites(this.excludeCipherSuites);
        }
        if (this.includeCipherSuites != null) {
            contextFactory.setIncludeCipherSuites(this.includeCipherSuites);
        }
        contextFactory.setWantClientAuth(this.tlsWantClientAuth);
        contextFactory.setNeedClientAuth(this.tlsNeedClientAuth);
    }

    private HttpConfiguration defaultHttpConfiguration() {
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme("https");
        httpsConfig.setSecurePort(this.port);
        httpsConfig.setOutputBufferSize(32768);
        httpsConfig.setRequestHeaderSize(8192);
        httpsConfig.setResponseHeaderSize(8192);
        httpsConfig.setSendServerVersion(true);
        httpsConfig.setSendDateHeader(false);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return httpsConfig;
    }

    public HttpConfiguration httpConfiguration() {
        if (this.httpConfiguration == null) {
            this.httpConfiguration = this.defaultHttpConfiguration();
        }
        return this.httpConfiguration;
    }

    public TLSServerConnectorBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public TLSServerConnectorBuilder withCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
        return this;
    }

    public TLSServerConnectorBuilder withCertificateKeyFile(String certificateKeyFile) {
        this.certificateKeyFile = certificateKeyFile;
        return this;
    }

    public TLSServerConnectorBuilder withCertificateKeyPassword(char[] certificateKeyPassword) {
        this.certicateKeyPassword = certificateKeyPassword;
        return this;
    }

    public TLSServerConnectorBuilder withNeedClientAuth(boolean needClientAuth) {
        this.tlsNeedClientAuth = needClientAuth;
        return this;
    }

    public TLSServerConnectorBuilder withWantClientAuth(boolean wantClientAuth) {
        this.tlsWantClientAuth = wantClientAuth;
        return this;
    }

    public TLSServerConnectorBuilder withIncludeProtocols(String ... includeProtocols) {
        this.includeProtocols = includeProtocols;
        return this;
    }

    public TLSServerConnectorBuilder withExcludeProtocols(String ... excludeProtocols) {
        this.excludeProtocols = excludeProtocols;
        return this;
    }

    public TLSServerConnectorBuilder withIncludeCipherSuites(String ... includeCipherSuites) {
        this.includeCipherSuites = includeCipherSuites;
        return this;
    }

    public TLSServerConnectorBuilder withExcludeCipherSuites(String ... excludeCipherSuites) {
        this.excludeCipherSuites = excludeCipherSuites;
        return this;
    }

    public TLSServerConnectorBuilder withHttpConfiguration(HttpConfiguration conf) {
        this.httpConfiguration = conf;
        return this;
    }

    public TLSServerConnectorBuilder withKeyManager(KeyManager km) {
        this.keyManager = km;
        return this;
    }

    private SSLContext buildSSLContext() {
        SSLContext sslCtx;
        try {
            KeyManager[] kms = new KeyManager[]{this.keyManager};
            SSLTrustManager tm = new SSLTrustManager((X509CertChainValidator)this.certificateValidator);
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kms, new TrustManager[]{tm}, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("TLS protocol not supported.", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        return sslCtx;
    }

    public ServerConnector build() {
        if (this.keyManager == null) {
            this.loadCredentials();
        }
        SSLContext sslContext = this.buildSSLContext();
        SslContextFactory cf = new SslContextFactory();
        cf.setSslContext(sslContext);
        this.configureContextFactory(cf);
        if (this.httpConfiguration == null) {
            this.httpConfiguration = this.defaultHttpConfiguration();
        }
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(cf, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(this.httpConfiguration)});
        connector.setPort(this.port);
        return connector;
    }

    private void checkFileExistsAndIsReadable(File f, String prefix) {
        String errorMessage = null;
        if (!f.exists()) {
            errorMessage = "File does not exists";
        } else if (!f.canRead()) {
            errorMessage = "File is not readable";
        } else if (f.isDirectory()) {
            errorMessage = "File is a directory";
        }
        if (errorMessage != null) {
            String msg = String.format("%s: %s [%s]", prefix, errorMessage, f.getAbsolutePath());
            throw new RuntimeException(msg);
        }
    }
}

