/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.jetty;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ThreadPoolBuilder {
    public static final int MAX_REQUEST_QUEUE_SIZE = 200;
    public static final int MAX_THREADS = 50;
    public static final int MIN_THREADS = 1;
    public static final int IDLE_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(60L);
    private int maxThreads = 50;
    private int minThreads = 1;
    private int idleTimeout = IDLE_TIMEOUT;
    private int maxRequestQueueSize;

    public static ThreadPoolBuilder instance() {
        return new ThreadPoolBuilder();
    }

    public ThreadPoolBuilder withMaxThreads(int maxNumberOfThreads) {
        this.maxThreads = maxNumberOfThreads;
        return this;
    }

    public ThreadPoolBuilder withMinThreads(int minNumberOfThreads) {
        this.minThreads = minNumberOfThreads;
        return this;
    }

    public ThreadPoolBuilder withMaxRequestQueueSize(int queueSize) {
        this.maxRequestQueueSize = queueSize;
        return this;
    }

    private ThreadPoolBuilder() {
    }

    public ThreadPool build() {
        if (this.maxRequestQueueSize <= 0) {
            this.maxRequestQueueSize = 200;
        }
        if (this.maxThreads <= 0) {
            this.maxThreads = 50;
        }
        if (this.minThreads <= 0) {
            this.minThreads = 1;
        }
        ArrayBlockingQueue queue = new ArrayBlockingQueue(200);
        QueuedThreadPool tp = new QueuedThreadPool(this.maxThreads, this.minThreads, this.idleTimeout, queue);
        return tp;
    }
}

