/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.credential.impl;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.PasswordSupplier;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.credential.LoadCredentialsEventListener;
import org.italiangrid.voms.credential.ProxyNamingPolicy;
import org.italiangrid.voms.credential.impl.AbstractLoadCredentialsStrategy;
import org.italiangrid.voms.credential.impl.DefaultProxyPathBuilder;
import org.italiangrid.voms.util.NullListener;

public class DefaultLoadCredentialsStrategy
extends AbstractLoadCredentialsStrategy {
    private static final String GLOBUS_PKCS12_CRED_PATH_SUFFIX = ".globus/usercred.p12";
    private static final String GLOBUS_PEM_CERT_PATH_SUFFIX = ".globus/usercert.pem";
    private static final String GLOBUS_PEM_KEY_PATH_SUFFIX = ".globus/userkey.pem";
    public static final String HOME_PROPERTY = "user.home";
    public static final String TMPDIR_PROPERTY = "java.io.tmpdir";
    public static final String TMPDIR_PATH = "/tmp";
    private static final ProxyNamingPolicy proxyPathBuilder = new DefaultProxyPathBuilder();
    private String home;
    private String tmpDir;

    public DefaultLoadCredentialsStrategy(String homeFolder, String tempDir, LoadCredentialsEventListener listener) {
        super(listener);
        this.home = homeFolder;
        this.tmpDir = tempDir;
        if (this.home == null) {
            throw new VOMSError("user.home not found in system properties!");
        }
    }

    public DefaultLoadCredentialsStrategy(String homeFolder) {
        this(homeFolder, System.getProperty(TMPDIR_PROPERTY), NullListener.INSTANCE);
    }

    public DefaultLoadCredentialsStrategy() {
        this(System.getProperty(HOME_PROPERTY), System.getProperty(TMPDIR_PROPERTY), NullListener.INSTANCE);
    }

    public DefaultLoadCredentialsStrategy(LoadCredentialsEventListener listener) {
        this(System.getProperty(HOME_PROPERTY), System.getProperty(TMPDIR_PROPERTY), listener);
    }

    public String getFromEnvOrSystemProperty(String propName) {
        String val = System.getenv(propName);
        if (val == null) {
            val = System.getProperty(propName);
        }
        return val;
    }

    @Override
    public X509Credential loadCredentials(PasswordSupplier pf) {
        if (pf == null) {
            throw new IllegalArgumentException("Please provide a non-null password finder!");
        }
        try {
            X509Credential cred = this.loadPEMCredentialFromEnv(pf);
            if (cred == null) {
                cred = this.loadPKCS12CredentialFromEnv(pf);
            }
            if (cred == null) {
                cred = this.loadPEMCredentialsFromGlobusDir(pf);
            }
            if (cred == null) {
                cred = this.loadPKCS12CredentialsFromGlobusDir(pf);
            }
            return cred;
        }
        catch (Exception e) {
            throw new VOMSError("Error loading credential: " + e.getMessage(), e);
        }
    }

    protected X509Credential loadProxyFromUID() {
        String uid = this.getFromEnvOrSystemProperty("VOMS_UID");
        if (uid != null) {
            String proxyFile = proxyPathBuilder.buildProxyFileName(this.tmpDir, Integer.parseInt(uid));
            return this.loadProxyCredential(proxyFile);
        }
        return null;
    }

    protected X509Credential loadProxyFromEnv() {
        String proxyPath = this.getFromEnvOrSystemProperty("X509_USER_PROXY");
        if (proxyPath != null) {
            return this.loadProxyCredential(proxyPath);
        }
        return null;
    }

    protected X509Credential loadPEMCredentialFromEnv(PasswordSupplier pf) {
        String certPath = this.getFromEnvOrSystemProperty("X509_USER_CERT");
        String keyPath = this.getFromEnvOrSystemProperty("X509_USER_KEY");
        if (certPath != null && keyPath != null) {
            return this.loadPEMCredential(keyPath, certPath, pf);
        }
        return null;
    }

    protected X509Credential loadPKCS12CredentialFromEnv(PasswordSupplier pf) {
        String pkcs12Path = this.getFromEnvOrSystemProperty("PKCS12_USER_CERT");
        if (pkcs12Path != null) {
            return this.loadPKCS12Credential(pkcs12Path, pf);
        }
        return null;
    }

    protected X509Credential loadPKCS12CredentialsFromGlobusDir(PasswordSupplier pf) {
        String credPath = String.format("%s/%s", this.home, GLOBUS_PKCS12_CRED_PATH_SUFFIX);
        return this.loadPKCS12Credential(credPath, pf);
    }

    protected X509Credential loadPEMCredentialsFromGlobusDir(PasswordSupplier pf) {
        String certPath = String.format("%s/%s", this.home, GLOBUS_PEM_CERT_PATH_SUFFIX);
        String keyPath = String.format("%s/%s", this.home, GLOBUS_PEM_KEY_PATH_SUFFIX);
        return this.loadPEMCredential(keyPath, certPath, pf);
    }
}

