/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.error;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.italiangrid.voms.error.VOMSValidationErrorCode;

public class VOMSValidationErrorMessage {
    static final String ERROR_BUNDLE = VOMSValidationErrorMessage.class.getPackage().getName() + ".validationErrors";
    private VOMSValidationErrorCode errorCode;
    private String message;
    private Object[] parameters;

    public static VOMSValidationErrorMessage newErrorMessage(VOMSValidationErrorCode errorCode) {
        return new VOMSValidationErrorMessage(errorCode);
    }

    public static VOMSValidationErrorMessage newErrorMessage(VOMSValidationErrorCode errorCode, Object ... params) {
        return new VOMSValidationErrorMessage(errorCode, params);
    }

    private VOMSValidationErrorMessage(VOMSValidationErrorCode errorCode) {
        this(errorCode, null);
    }

    private VOMSValidationErrorMessage(VOMSValidationErrorCode errorCode, Object ... params) {
        this.errorCode = errorCode;
        this.parameters = params;
        ResourceBundle bundle = ResourceBundle.getBundle(ERROR_BUNDLE);
        String template = null;
        try {
            template = bundle.getString(errorCode.name());
        }
        catch (MissingResourceException e) {
            template = "Other error";
        }
        this.message = MessageFormat.format(template, this.parameters);
    }

    public VOMSValidationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String toString() {
        return String.format("[%s]:%s", this.errorCode.name(), this.message);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VOMSValidationErrorMessage other = (VOMSValidationErrorMessage)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

