/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.italiangrid.voms.VOMSGenericAttribute;
import org.italiangrid.voms.ac.impl.VOMSGenericAttributeImpl;
import org.italiangrid.voms.request.impl.FakeVOMSACServiceProperties;

public class ACGenerationParams {
    final String vo;
    final List<String> fqans;
    final List<VOMSGenericAttribute> gas;
    final String host;
    final int port;
    final Date notBefore;
    final Date notAfter;
    final BigInteger serialNo;

    private ACGenerationParams(Builder builder) {
        this.vo = builder.vo;
        this.fqans = builder.fqans;
        this.gas = builder.gas;
        this.host = builder.host;
        this.port = builder.port;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.serialNo = builder.serialNo;
    }

    public String getVo() {
        return this.vo;
    }

    public List<String> getFqans() {
        return this.fqans;
    }

    public List<VOMSGenericAttribute> getGas() {
        return this.gas;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ACGenerationParams fromSystemProperties() {
        Builder builder = ACGenerationParams.builder();
        builder.vo(FakeVOMSACServiceProperties.VO.getSystemPropertyValue());
        String fqansString = FakeVOMSACServiceProperties.FQANS.getSystemPropertyValue();
        for (String f : fqansString.split(",")) {
            String trimmedFqan = f.trim();
            if (trimmedFqan.isEmpty()) continue;
            builder.fqan(trimmedFqan);
        }
        builder.host(FakeVOMSACServiceProperties.HOST.getSystemPropertyValue());
        builder.port(Integer.parseInt(FakeVOMSACServiceProperties.PORT.getSystemPropertyValue()));
        builder.serialNo(Long.parseLong(FakeVOMSACServiceProperties.SERIAL.getSystemPropertyValue()));
        return builder.build();
    }

    public static class Builder {
        String vo = "test";
        List<String> fqans;
        List<VOMSGenericAttribute> gas;
        String host = "voms.example";
        int port = 15000;
        Date notBefore;
        Date notAfter;
        BigInteger serialNo = BigInteger.valueOf(0L);

        public Builder() {
            this.fqans = new ArrayList<String>();
            this.gas = new ArrayList<VOMSGenericAttribute>();
        }

        public Builder vo(String vo) {
            this.vo = vo;
            return this;
        }

        public Builder fqan(String fqan) {
            this.fqans.add(fqan);
            return this;
        }

        public Builder ga(String name, String value, String context) {
            VOMSGenericAttributeImpl ga = new VOMSGenericAttributeImpl();
            ga.setName(name);
            ga.setValue(value);
            ga.setContext(context);
            this.gas.add(ga);
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder notBefore(Date notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public Builder notAfter(Date notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public Builder serialNo(long serialNo) {
            this.serialNo = BigInteger.valueOf(serialNo);
            return this;
        }

        public ACGenerationParams build() {
            return new ACGenerationParams(this);
        }
    }
}

