/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.asn1.VOMSACGenerator;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSACService;
import org.italiangrid.voms.request.VOMSRequestListener;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.impl.ACGenerationParams;
import org.italiangrid.voms.request.impl.DefaultVOMSServerInfo;
import org.italiangrid.voms.request.impl.FakeVOMSACServiceProperties;

public class FakeVOMSACService
implements VOMSACService {
    final VOMSACGenerator acGenerator;
    final VOMSRequestListener listener;
    ACGenerationParams acParams;
    long acSerialNumber = 0L;

    private FakeVOMSACService(X509Credential aaCredential, ACGenerationParams acParams, VOMSRequestListener listener) {
        this.acGenerator = new VOMSACGenerator(aaCredential);
        this.listener = listener;
        this.acParams = acParams;
    }

    private VOMSServerInfo buildFakeServerInfo(String vo, String host, int port) throws URISyntaxException {
        DefaultVOMSServerInfo info = new DefaultVOMSServerInfo();
        info.setAlias("Fake local VOMS server");
        info.setVoName(vo);
        String vomsUri = String.format("voms://%s:%d", host, port);
        info.setURL(new URI(vomsUri));
        return info;
    }

    protected X509AttributeCertificateHolder buildAC(X509Credential credential, VOMSACRequest request) {
        Date notAfter;
        Date notBefore;
        BigInteger serialNo;
        String vo;
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        List<String> fqans = request.getRequestedFQANs();
        if (Objects.isNull(fqans) || fqans.isEmpty()) {
            fqans = this.acParams.getFqans();
        }
        if (Objects.isNull(vo = request.getVoName())) {
            vo = this.acParams.getVo();
        }
        if (Objects.isNull(serialNo = this.acParams.getSerialNo())) {
            serialNo = BigInteger.valueOf(this.acSerialNumber++);
        }
        if (Objects.isNull(notBefore = this.acParams.getNotBefore())) {
            notBefore = now;
        }
        if (Objects.isNull(notAfter = this.acParams.getNotAfter())) {
            cal.add(13, request.getLifetime());
            notAfter = cal.getTime();
        }
        try {
            VOMSServerInfo fakeEndpoint = this.buildFakeServerInfo(vo, this.acParams.getHost(), this.acParams.getPort());
            this.listener.notifyVOMSRequestStart(request, fakeEndpoint);
            X509AttributeCertificateHolder ac = this.acGenerator.generateVOMSAttributeCertificate(fqans, this.acParams.getGas(), request.getTargets(), credential.getCertificate(), serialNo, notBefore, notAfter, vo, this.acParams.getHost(), this.acParams.getPort());
            this.listener.notifyVOMSRequestSuccess(request, fakeEndpoint);
            return ac;
        }
        catch (URISyntaxException e) {
            throw new VOMSError(e.getMessage(), e);
        }
    }

    @Override
    public AttributeCertificate getVOMSAttributeCertificate(X509Credential credential, VOMSACRequest request) {
        X509AttributeCertificateHolder acHolder = this.buildAC(credential, request);
        return acHolder.toASN1Structure();
    }

    public ACGenerationParams getAcParams() {
        return this.acParams;
    }

    public void setAcParams(ACGenerationParams acParams) {
        this.acParams = acParams;
    }

    public long getAcSerialNumber() {
        return this.acSerialNumber;
    }

    public void setAcSerialNumber(long acSerialNumber) {
        this.acSerialNumber = acSerialNumber;
    }

    public static FakeVOMSACService newInstance(X509Credential aaCredential, ACGenerationParams params, VOMSRequestListener listener) {
        return new FakeVOMSACService(aaCredential, params, listener);
    }

    public static FakeVOMSACService newInstanceFromProperties(VOMSRequestListener listener) {
        String aaCert = FakeVOMSACServiceProperties.AA_CERT.getSystemPropertyValue();
        String aaKey = FakeVOMSACServiceProperties.AA_KEY.getSystemPropertyValue();
        if (Objects.isNull(aaCert)) {
            throw new VOMSError(String.format("%s is not set", FakeVOMSACServiceProperties.AA_CERT.name()));
        }
        if (Objects.isNull(aaKey)) {
            throw new VOMSError(String.format("%s is not set", FakeVOMSACServiceProperties.AA_KEY.name()));
        }
        try {
            PEMCredential aaCredential = new PEMCredential(aaKey, aaCert, null);
            ACGenerationParams acParams = ACGenerationParams.fromSystemProperties();
            return new FakeVOMSACService((X509Credential)aaCredential, acParams, listener);
        }
        catch (Exception e) {
            String errorMsg = String.format("Error loading VOMS fake AC AA credential from '%s' and '%s': %s", aaKey, aaCert, e.getMessage());
            throw new VOMSError(errorMsg, e);
        }
    }
}

