/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.store.impl;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.store.UpdatingVOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.impl.DefaultVOMSTrustStore;
import org.italiangrid.voms.store.impl.VOMSNamedThreadFactory;
import org.italiangrid.voms.util.NullListener;

public class DefaultUpdatingVOMSTrustStore
extends DefaultVOMSTrustStore
implements UpdatingVOMSTrustStore {
    public static final long DEFAULT_UPDATE_FREQUENCY = TimeUnit.MINUTES.toMillis(10L);
    private long updateFrequency;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new VOMSNamedThreadFactory());

    public DefaultUpdatingVOMSTrustStore(List<String> localTrustDirs, long updateFrequency, VOMSTrustStoreStatusListener listener) {
        super(localTrustDirs, listener);
        this.updateFrequencySanityChecks(updateFrequency);
        this.updateFrequency = updateFrequency;
        this.scheduleUpdate();
    }

    public DefaultUpdatingVOMSTrustStore(long updateFrequency) {
        this(DefaultUpdatingVOMSTrustStore.buildDefaultTrustedDirs(), updateFrequency, NullListener.INSTANCE);
    }

    public DefaultUpdatingVOMSTrustStore(List<String> localTrustDirs, long updateFrequency) {
        this(localTrustDirs, updateFrequency, NullListener.INSTANCE);
    }

    public DefaultUpdatingVOMSTrustStore(List<String> localTrustDirs) {
        this(localTrustDirs, DEFAULT_UPDATE_FREQUENCY, NullListener.INSTANCE);
    }

    public DefaultUpdatingVOMSTrustStore() {
        this(DefaultUpdatingVOMSTrustStore.buildDefaultTrustedDirs(), DEFAULT_UPDATE_FREQUENCY, NullListener.INSTANCE);
    }

    protected void updateFrequencySanityChecks(long updateFrequency) {
        if (updateFrequency <= 0L) {
            throw new VOMSError("Please provide a positive value for this store update frequency!");
        }
    }

    protected void scheduleUpdate() {
        this.write.lock();
        try {
            long frequency = this.getUpdateFrequency();
            this.scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    DefaultUpdatingVOMSTrustStore.this.update();
                }
            }, frequency, frequency, TimeUnit.MILLISECONDS);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public long getUpdateFrequency() {
        this.read.lock();
        try {
            long l = this.updateFrequency;
            return l;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void update() {
        this.loadTrustInformation();
    }

    @Override
    public void cancel() {
        this.write.lock();
        try {
            this.scheduler.shutdownNow();
        }
        finally {
            this.write.unlock();
        }
    }
}

