/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.EnumSet;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.credential.FilePermissionError;

public class FilePermissionHelper {
    public static final EnumSet<PosixFilePermission> PRIVATE_KEY_PERMS = EnumSet.of(PosixFilePermission.USER_RO, PosixFilePermission.USER_RW);
    public static final String PRIVATE_KEY_PERMS_STR = PosixFilePermission.USER_RO.chmodForm() + ", " + PosixFilePermission.USER_RW.chmodForm();
    public static final String LS_CMD_TEMPLATE = "ls -al %s";
    public static final String CHMOD_CMD_TEMPLATE = "chmod %s %s";

    public static void checkProxyPermissions(String proxyFile) throws IOException {
        FilePermissionHelper.matchesFilePermissions(proxyFile, PosixFilePermission.USER_RW);
    }

    public static void checkPrivateKeyPermissions(String privateKeyFile) throws IOException {
        for (PosixFilePermission p : PRIVATE_KEY_PERMS) {
            try {
                FilePermissionHelper.matchesFilePermissions(privateKeyFile, p);
                return;
            }
            catch (FilePermissionError filePermissionError) {
            }
        }
        String errorMessage = String.format("Wrong file permissions on file %s. Required permissions are: %s ", privateKeyFile, PRIVATE_KEY_PERMS_STR);
        throw new FilePermissionError(errorMessage);
    }

    public static void checkPKCS12Permissions(String pkcs12File) throws IOException {
        FilePermissionHelper.matchesFilePermissions(pkcs12File, PosixFilePermission.USER_RW);
    }

    public static void matchesFilePermissions(String filename, PosixFilePermission p) throws IOException {
        FilePermissionHelper.filenameSanityChecks(filename);
        if (p == null) {
            throw new NullPointerException("null permission passed as argument");
        }
        File f = new File(filename);
        String canonicalPath = f.getCanonicalPath();
        String filePerms = FilePermissionHelper.getFilePermissions(canonicalPath);
        if (!filePerms.startsWith(p.statForm)) {
            throw new FilePermissionError("Wrong file permissions on file " + filename + ". Required permissions are: " + p.chmodForm());
        }
    }

    private static void filenameSanityChecks(String filename) {
        if (filename == null) {
            throw new NullPointerException("null filename passed as argument");
        }
        File f = new File(filename);
        if (!f.exists()) {
            throw new VOMSError("File not found: " + filename);
        }
    }

    private static String getFilePermissions(String filename) {
        String cmd = String.format(LS_CMD_TEMPLATE, filename);
        ProcessBuilder pb = new ProcessBuilder(cmd.split(" "));
        try {
            Process p = pb.start();
            int exitStatus = p.waitFor();
            if (exitStatus != 0) {
                throw new VOMSError("Cannot list properties for file '" + filename + "': error invoking the '" + cmd + "' os command!");
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String permString = r.readLine();
            if (permString == null) {
                throw new VOMSError("Cannot list properties for file '" + filename + "': the output of '" + cmd + "' is empty!");
            }
            return permString;
        }
        catch (IOException e) {
            throw new VOMSError("Cannot list properties for file '" + filename + "': " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static void setProxyPermissions(String filename) {
        FilePermissionHelper.filenameSanityChecks(filename);
        FilePermissionHelper.setFilePermissions(filename, PosixFilePermission.USER_RW);
    }

    public static void setPKCS12Permissions(String filename) {
        FilePermissionHelper.filenameSanityChecks(filename);
        FilePermissionHelper.setFilePermissions(filename, PosixFilePermission.USER_RW);
    }

    public static void setPrivateKeyPermissions(String filename) {
        FilePermissionHelper.filenameSanityChecks(filename);
        FilePermissionHelper.setFilePermissions(filename, PosixFilePermission.USER_RO);
    }

    public static void setFilePermissions(String filename, PosixFilePermission perm) {
        String cmd = String.format(CHMOD_CMD_TEMPLATE, perm.chmodForm(), filename);
        ProcessBuilder pb = new ProcessBuilder(cmd.split(" "));
        try {
            Process p = pb.start();
            int exitStatus = p.waitFor();
            if (exitStatus != 0) {
                throw new VOMSError("Cannot change permissions on file '" + filename + "': error invoking the '" + cmd + "' os command!");
            }
        }
        catch (IOException e) {
            throw new VOMSError("Cannot list properties for file '" + filename + "': " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new VOMSError("Interrupted while running os command!", e);
        }
    }

    public static enum PosixFilePermission {
        USER_RO("400", "-r--------"),
        USER_RW("600", "-rw-------"),
        USER_ALL("700", "-rwx------"),
        ALL_PERMS("777", "-rwxrwxrwx");

        private String statForm;
        private String chmodForm;

        private PosixFilePermission(String chmodForm, String statForm) {
            this.chmodForm = chmodForm;
            this.statForm = statForm;
        }

        public String statForm() {
            return this.statForm;
        }

        public String chmodForm() {
            return this.chmodForm;
        }
    }
}

