/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    private TimeUtils() {
    }

    public static boolean checkTimeInRangeWithSkew(Date timeToCheck, Date startDate, Date endDate, int skewInMinutes) {
        if (startDate.after(endDate) || startDate.equals(endDate)) {
            String msg = String.format("Illegal time interval: start date must be before end date. [start date: %s, end date: %s]", startDate, endDate);
            throw new IllegalArgumentException(msg);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.add(12, -skewInMinutes);
        Date skewedStartDate = cal.getTime();
        cal.clear();
        cal.setTime(endDate);
        cal.add(12, skewInMinutes);
        Date skewedEndDate = cal.getTime();
        return skewedEndDate.after(timeToCheck) && skewedStartDate.before(timeToCheck);
    }
}

