/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.italiangrid.voms.VOMSError;

public class VOMSFQANNamingScheme {
    public static final String fqanSyntax = "^(/[\\w.-]+)+|((/[\\w.-]+)+/)?(Role=[\\w.-]+)|(Capability=[\\w\\s.-]+)$";
    public static final String groupSyntax = "^(/[\\w.-]+)+$";
    public static final String roleSyntax = "^Role=[\\w.-]+$";
    public static final String qualifiedRoleSyntax = "^(/[\\w.-]+)+/Role=[\\w.-]+$";
    public static final String capabilitySyntax = "^Capability=[\\w\\s.-]+$";
    public static final Pattern fqanPattern = Pattern.compile("^(/[\\w.-]+)+|((/[\\w.-]+)+/)?(Role=[\\w.-]+)|(Capability=[\\w\\s.-]+)$");
    public static final Pattern groupPattern = Pattern.compile("^(/[\\w.-]+)+$");
    public static final Pattern rolePattern = Pattern.compile("^Role=[\\w.-]+$");
    public static final Pattern qualifiedRolePattern = Pattern.compile("^(/[\\w.-]+)+/Role=[\\w.-]+$");
    public static final Pattern capabilityPattern = Pattern.compile("^Capability=[\\w\\s.-]+$");

    public static void checkSyntax(String fqan) {
        if (fqan.length() > 255) {
            throw new VOMSError("fqan.length() > 255");
        }
        if (!fqanPattern.matcher(fqan).matches()) {
            throw new VOMSError("Syntax error in fqan: " + fqan);
        }
    }

    public static void checkGroup(String fqan) {
        VOMSFQANNamingScheme.checkSyntax(fqan);
        if (!groupPattern.matcher(fqan).matches()) {
            throw new VOMSError("Syntax error in group name: " + fqan);
        }
    }

    public static void checkRole(String roleName) {
        if (roleName.length() > 255) {
            throw new VOMSError("roleName.length()>255");
        }
        if (!rolePattern.matcher(roleName).matches()) {
            throw new VOMSError("Syntax error in role name: " + roleName);
        }
    }

    public static boolean isGroup(String groupName) {
        VOMSFQANNamingScheme.checkSyntax(groupName);
        return groupPattern.matcher(groupName).matches();
    }

    public static boolean isRole(String roleName) {
        VOMSFQANNamingScheme.checkSyntax(roleName);
        return rolePattern.matcher(roleName).matches();
    }

    public static boolean isQualifiedRole(String fqan) {
        VOMSFQANNamingScheme.checkSyntax(fqan);
        return qualifiedRolePattern.matcher(fqan).matches();
    }

    public static String getRoleName(String containerName) {
        if (!VOMSFQANNamingScheme.isRole(containerName) && !VOMSFQANNamingScheme.isQualifiedRole(containerName)) {
            throw new VOMSError("No role specified in \"" + containerName + "\" voms syntax.");
        }
        Matcher m = fqanPattern.matcher(containerName);
        if (m.matches()) {
            String roleGroup = m.group(4);
            return roleGroup.substring(roleGroup.indexOf(61) + 1, roleGroup.length());
        }
        return null;
    }

    public static String getGroupName(String containerName) {
        VOMSFQANNamingScheme.checkSyntax(containerName);
        if (!VOMSFQANNamingScheme.isRole(containerName) && !VOMSFQANNamingScheme.isQualifiedRole(containerName)) {
            return containerName;
        }
        Matcher m = fqanPattern.matcher(containerName);
        if (m.matches()) {
            String groupName = m.group(2);
            if (groupName.endsWith("/")) {
                return groupName.substring(0, groupName.length() - 1);
            }
            return groupName;
        }
        return null;
    }

    public static String toOldQualifiedRoleSyntax(String qualifiedRole) {
        VOMSFQANNamingScheme.checkSyntax(qualifiedRole);
        if (!VOMSFQANNamingScheme.isQualifiedRole(qualifiedRole)) {
            throw new VOMSError("String passed as argument is not a qualified role!");
        }
        return VOMSFQANNamingScheme.getGroupName(qualifiedRole) + ":" + VOMSFQANNamingScheme.getRoleName(qualifiedRole);
    }
}

