/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher;

import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class MismatchReporter {
    private final Description mismatchDescription;
    private boolean firstMismatch = true;
    private boolean matches = true;

    private MismatchReporter(Description mismatchDescription) {
        this.mismatchDescription = mismatchDescription;
    }

    static MismatchReporter start(Description mismatchDescription) {
        mismatchDescription.appendText("{");
        return new MismatchReporter(mismatchDescription);
    }

    boolean finishAndCheckMatching() {
        this.mismatchDescription.appendText("}");
        return this.matches;
    }

    public <T> MismatchReporter checkMismatch(String message, Matcher<T> matcher, T actual) {
        if (!matcher.matches(actual)) {
            this.reportMismatch(message, matcher, actual);
            this.matches = false;
        }
        return this;
    }

    private void reportMismatch(String name, Matcher<?> matcher, Object actual) {
        this.appendComma();
        this.mismatchDescription.appendText(name).appendText(" ");
        matcher.describeMismatch(actual, this.mismatchDescription);
    }

    private void appendComma() {
        if (!this.firstMismatch) {
            this.mismatchDescription.appendText(", ");
        }
        this.firstMismatch = false;
    }
}

