/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher.auto;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

class OptionalMatchers {
    static Matcher<Optional<?>> isEmpty() {
        return new EmptyMatcher();
    }

    static <T> Matcher<Optional<T>> isPresentAnd(Matcher<? super T> matcher) {
        return new HasValue<T>(matcher);
    }

    private OptionalMatchers() {
    }

    private static class HasValue<T>
    extends TypeSafeMatcher<Optional<T>> {
        private final Matcher<? super T> matcher;

        public HasValue(Matcher<? super T> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has value that is ");
            this.matcher.describeTo(description);
        }

        protected boolean matchesSafely(Optional<T> item) {
            return item.isPresent() && this.matcher.matches(item.get());
        }

        protected void describeMismatchSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                mismatchDescription.appendText("value ");
                this.matcher.describeMismatch(item.get(), mismatchDescription);
            } else {
                mismatchDescription.appendText("was <Empty>");
            }
        }
    }

    private static class EmptyMatcher
    extends TypeSafeMatcher<Optional<?>> {
        private EmptyMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is <Empty>");
        }

        protected boolean matchesSafely(Optional<?> item) {
            return !item.isPresent();
        }

        protected void describeMismatchSafely(Optional<?> item, Description mismatchDescription) {
            mismatchDescription.appendText("had value ");
            mismatchDescription.appendValue(item.orElseThrow());
        }
    }
}

