/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher.auto;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArray;
import org.hamcrest.collection.IsMapContaining;
import org.itsallcode.matcher.auto.AutoMatcher;
import org.itsallcode.matcher.auto.OptionalMatchers;
import org.itsallcode.matcher.config.ConfigurableMatcher;
import org.itsallcode.matcher.config.MatcherConfig;

class AutoConfigBuilder<T> {
    private static final Logger LOG = Logger.getLogger(AutoConfigBuilder.class.getName());
    private static final Set<Class<?>> SIMPLE_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(String.class, Long.class, Integer.class, Byte.class, Boolean.class, Float.class, Double.class, Character.class, Short.class, BigInteger.class, BigDecimal.class, Calendar.class, java.util.Date.class, Date.class, Timestamp.class, Instant.class, LocalDate.class, Temporal.class, Currency.class, File.class, Path.class, UUID.class, Class.class, Package.class, Enum.class, URL.class, URI.class)));
    private static final Set<String> IGNORED_METHOD_NAMES = new HashSet<String>(Arrays.asList("getClass", "getProtectionDomain", "getClassLoader", "getURLs", "hashCode", "toString"));
    private final T expected;
    private final MatcherConfig.Builder<T> configBuilder;
    private final boolean isRecord;

    AutoConfigBuilder(T expected, boolean isRecord) {
        this.expected = expected;
        this.isRecord = isRecord;
        this.configBuilder = MatcherConfig.builder(expected);
    }

    MatcherConfig<T> build() {
        Arrays.stream(this.expected.getClass().getMethods()).filter(this::isNotIgnored).filter(this::isGetterMethodName).filter(this::isGetterMethodSignature).sorted(Comparator.comparing(this::hasSimpleReturnType).reversed().thenComparing(this::hasArrayReturnType).thenComparing(Method::getName)).forEach(this::addConfigForGetter);
        return this.configBuilder.build();
    }

    static <T> Matcher<T> createEqualToMatcher(T expected) {
        if (expected == null) {
            return Matchers.nullValue();
        }
        Class<?> type = expected.getClass();
        if (type.isArray()) {
            return AutoConfigBuilder.createArrayMatcher(expected);
        }
        if (AutoConfigBuilder.isSimpleType(type)) {
            return Matchers.equalTo(expected);
        }
        if (Map.class.isAssignableFrom(type)) {
            return AutoConfigBuilder.createMapContainsMatcher(expected);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return AutoConfigBuilder.createIterableContainsMatcher(expected);
        }
        if (Optional.class.isAssignableFrom(type)) {
            return AutoConfigBuilder.createOptionalMatcher(expected);
        }
        MatcherConfig<T> config = AutoConfigBuilder.create(expected).build();
        return new ConfigurableMatcher<T>(config);
    }

    static <T> AutoConfigBuilder<T> create(T expected) {
        return new AutoConfigBuilder<T>(expected, AutoConfigBuilder.isRecord(expected.getClass()));
    }

    private static boolean isRecord(Class<?> type) {
        Method isRecord;
        try {
            isRecord = type.getClass().getMethod("isRecord", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.log(Level.FINEST, e, () -> "Method Class.isRecord() does not exist, " + type.getName() + " is probably not a record");
            return false;
        }
        try {
            return (Boolean)isRecord.invoke(type, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.log(Level.WARNING, e, () -> "Invocation of " + isRecord + " failed for " + type);
            return false;
        }
    }

    private static <T> Matcher<T> createArrayMatcher(Object expected) {
        Class<?> componentType = expected.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            return Matchers.equalTo((Object)expected);
        }
        Object[] expectedArray = (Object[])expected;
        if (expectedArray.length == 0) {
            return Matchers.emptyArray();
        }
        if (AutoConfigBuilder.isSimpleType(componentType)) {
            Matcher arrayContaining = Matchers.arrayContaining((Object[])expectedArray);
            return arrayContaining;
        }
        List<Matcher> matchers = Arrays.stream(expectedArray).map(AutoMatcher::equalTo).collect(Collectors.toList());
        IsArray arrayContaining = IsArray.array((Matcher[])matchers.toArray(new Matcher[0]));
        return arrayContaining;
    }

    private static <T, K, V> Matcher<T> createMapContainsMatcher(T expected) {
        Map expectedMap = (Map)expected;
        ArrayList<ConfigurableMatcher<T>> matchers = new ArrayList<ConfigurableMatcher<T>>();
        matchers.add(AutoConfigBuilder.mapSizeMatcher(expectedMap));
        for (Map.Entry expectedEntry : expectedMap.entrySet()) {
            matchers.add((ConfigurableMatcher<T>)IsMapContaining.hasEntry(AutoConfigBuilder.createEqualToMatcher(expectedEntry.getKey()), AutoConfigBuilder.createEqualToMatcher(expectedEntry.getValue())));
        }
        return Matchers.allOf(matchers);
    }

    private static <T, K, V> ConfigurableMatcher<T> mapSizeMatcher(Map<K, V> expectedMap) {
        MatcherConfig<Map> config = MatcherConfig.builder(expectedMap).addEqualsProperty("size", Map::size).build();
        return new ConfigurableMatcher<Map>(config);
    }

    private static <T> Matcher<T> createIterableContainsMatcher(T expected) {
        Iterable expectedIterable = (Iterable)expected;
        Object[] elements = StreamSupport.stream(expectedIterable.spliterator(), false).toArray();
        if (expected instanceof Set) {
            Matcher<Iterable<Object>> matcher = AutoMatcher.containsInAnyOrder(elements);
            return matcher;
        }
        Matcher<Iterable<Object>> matcher = AutoMatcher.contains(elements);
        return matcher;
    }

    private static <T> Matcher<T> createOptionalMatcher(T expected) {
        Optional expectedOptional = (Optional)expected;
        if (expectedOptional.isEmpty()) {
            return OptionalMatchers.isEmpty();
        }
        return OptionalMatchers.isPresentAnd(AutoMatcher.equalTo(expectedOptional.get()));
    }

    private boolean isNotIgnored(Method method) {
        return !IGNORED_METHOD_NAMES.contains(method.getName());
    }

    private boolean isGetterMethodSignature(Method method) {
        return method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private boolean isGetterMethodName(Method method) {
        if (this.isRecord) {
            return true;
        }
        String methodName = method.getName();
        return methodName.startsWith("get") || methodName.startsWith("is");
    }

    private void addConfigForGetter(Method method) {
        String propertyName = AutoConfigBuilder.getPropertyName(method.getName());
        LOG.finest(() -> "Adding general property '" + propertyName + "' for getter " + method);
        this.configBuilder.addProperty(propertyName, this.createGetter(method), AutoMatcher::equalTo);
    }

    private boolean hasArrayReturnType(Method method) {
        return method.getReturnType().isArray();
    }

    private <P> Function<T, P> createGetter(Method method) {
        return object -> AutoConfigBuilder.getPropertyValue(method, object);
    }

    private boolean hasSimpleReturnType(Method method) {
        Class<?> type = method.getReturnType();
        if (type.isPrimitive() || type.isEnum()) {
            return true;
        }
        return AutoConfigBuilder.isSimpleType(type);
    }

    private static boolean isSimpleType(Class<? extends Object> type) {
        for (Class<? extends Object> clazz : SIMPLE_TYPES) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    static String getPropertyName(String methodName) {
        int prefixLength;
        if (methodName.startsWith("get")) {
            prefixLength = 3;
        } else if (methodName.startsWith("is")) {
            prefixLength = 2;
        } else {
            return methodName;
        }
        if (methodName.length() == prefixLength) {
            return methodName;
        }
        String propertyName = methodName.substring(prefixLength);
        return AutoConfigBuilder.decapitalize(propertyName);
    }

    private static String decapitalize(String string) {
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    private static <T, P> P getPropertyValue(Method method, T object) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (!declaringClass.isInstance(object)) {
            throw new AssertionError((Object)("Expected object of type " + declaringClass.getName() + " but got " + object.getClass().getName() + ": " + object.toString()));
        }
        if (!Modifier.isPublic(declaringClass.getModifiers())) {
            method.setAccessible(true);
        }
        try {
            return (P)method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("Error invoking method " + method + " on object " + object + " of type " + object.getClass().getName(), e);
        }
    }
}

