/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher.auto;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.itsallcode.matcher.auto.AutoConfigBuilder;

public final class AutoMatcher {
    private AutoMatcher() {
    }

    public static <T> Matcher<T> equalTo(T expected) {
        return AutoConfigBuilder.createEqualToMatcher(expected);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<? extends T>> contains(T ... expected) {
        if (expected.length == 0) {
            return Matchers.emptyIterable();
        }
        return Matchers.contains(AutoMatcher.getMatchers(expected));
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(T ... expected) {
        if (expected.length == 0) {
            return Matchers.emptyIterable();
        }
        return Matchers.containsInAnyOrder(AutoMatcher.getMatchers(expected));
    }

    private static <T> List<Matcher<? super T>> getMatchers(T[] expected) {
        return Arrays.stream(expected).map(AutoMatcher::equalTo).collect(Collectors.toList());
    }
}

