/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher.config;

import org.hamcrest.SelfDescribing;
import org.itsallcode.matcher.BaseTypeSafeDiagnosingMatcher;
import org.itsallcode.matcher.DescriptionBuilder;
import org.itsallcode.matcher.MismatchReporter;
import org.itsallcode.matcher.config.MatcherConfig;
import org.itsallcode.matcher.config.PropertyConfig;

public class ConfigurableMatcher<T>
extends BaseTypeSafeDiagnosingMatcher<T> {
    private final MatcherConfig<T> config;

    public ConfigurableMatcher(MatcherConfig<T> config) {
        super(config.getExpected());
        this.config = config;
    }

    @Override
    protected final void describeTo(DescriptionBuilder description) {
        for (PropertyConfig<T, Object> property : this.config.getPropertyConfigs()) {
            description.append(property.getPropertyName(), (SelfDescribing)property.getMatcher());
        }
    }

    @Override
    protected final void reportMismatches(T actual, MismatchReporter mismatchReporter) {
        for (PropertyConfig<T, Object> property : this.config.getPropertyConfigs()) {
            this.reportMismatch(actual, mismatchReporter, property);
        }
    }

    private <P> void reportMismatch(T actual, MismatchReporter mismatchReporter, PropertyConfig<T, P> property) {
        mismatchReporter.checkMismatch(property.getPropertyName(), property.getMatcher(), property.getPropertyValue(actual));
    }
}

