/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.matcher.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.itsallcode.matcher.config.PropertyConfig;

public final class MatcherConfig<T> {
    private final T expected;
    private final List<PropertyConfig<T, ?>> propertyConfigs;

    private MatcherConfig(T expected, List<PropertyConfig<T, ?>> propertyConfigs) {
        this.expected = expected;
        this.propertyConfigs = Collections.unmodifiableList(propertyConfigs);
    }

    T getExpected() {
        return this.expected;
    }

    public List<PropertyConfig<T, Object>> getPropertyConfigs() {
        return this.propertyConfigs.stream().map(c -> c).collect(Collectors.toList());
    }

    public static <B> Builder<B> builder(B expected) {
        return new Builder<B>(expected);
    }

    private static class NullIterableMatcher<T>
    extends BaseMatcher<Iterable<T>> {
        private NullIterableMatcher() {
        }

        public boolean matches(Object item) {
            return item == null;
        }

        public void describeTo(Description description) {
            description.appendText("null");
        }
    }

    public static final class Builder<B> {
        private final B expected;
        private final List<PropertyConfig<B, ?>> properties = new ArrayList();

        private Builder(B expected) {
            this.expected = Objects.requireNonNull(expected);
        }

        public <P> Builder<B> addEqualsProperty(String propertyName, Function<B, P> propertyAccessor) {
            return this.addProperty(propertyName, propertyAccessor, Matchers::equalTo);
        }

        public <P> Builder<B> addProperty(String propertyName, Function<B, P> propertyAccessor, Function<P, Matcher<P>> matcherBuilder) {
            Matcher<P> matcher = this.createMatcher(propertyAccessor, matcherBuilder);
            return this.addPropertyInternal(propertyName, matcher, propertyAccessor);
        }

        private <P> Matcher<P> createMatcher(Function<B, P> propertyAccessor, Function<P, Matcher<P>> matcherBuilder) {
            P expectedValue = propertyAccessor.apply(this.expected);
            if (expectedValue == null) {
                return Matchers.nullValue();
            }
            return matcherBuilder.apply(expectedValue);
        }

        public <P> Builder<B> addIterableProperty(String propertyName, Function<B, Iterable<? extends P>> propertyAccessor, Function<P, Matcher<P>> matcherBuilder) {
            Iterable<? extends P> expectedPropertyValue = propertyAccessor.apply(this.expected);
            Matcher<Iterable<? extends P>> listMatcher = this.createListMatcher(matcherBuilder, expectedPropertyValue);
            return this.addPropertyInternal(propertyName, listMatcher, propertyAccessor);
        }

        private <P> Matcher<Iterable<? extends P>> createListMatcher(Function<P, Matcher<P>> matcherBuilder, Iterable<? extends P> expectedPropertyValue) {
            if (expectedPropertyValue == null) {
                return this.createNullIterableMatcher();
            }
            if (!expectedPropertyValue.iterator().hasNext()) {
                return Matchers.emptyIterable();
            }
            List matchers = StreamSupport.stream(expectedPropertyValue.spliterator(), false).map(matcherBuilder).collect(Collectors.toList());
            return Matchers.contains(matchers);
        }

        private <P> Matcher<Iterable<? extends P>> createNullIterableMatcher() {
            return new NullIterableMatcher();
        }

        private <P> Builder<B> addPropertyInternal(String propertyName, Matcher<P> matcher, Function<B, P> propertyAccessor) {
            this.properties.add(new PropertyConfig<B, P>(propertyName, matcher, propertyAccessor));
            return this;
        }

        public MatcherConfig<B> build() {
            if (this.properties.isEmpty()) {
                throw new IllegalArgumentException("Failed to build MatcherConfig: Class " + this.expected.getClass().getName() + " has no properties.");
            }
            return new MatcherConfig<B>(this.expected, new ArrayList(this.properties));
        }
    }
}

