/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic;

import java.time.LocalDate;
import org.itsallcode.holidays.calculator.logic.Holiday;

public class FixedDateHoliday
extends Holiday {
    private final int month;
    private final int day;

    public FixedDateHoliday(String category, String name, int month, int day) {
        super(category, name);
        this.month = month;
        this.day = day;
        this.ensureValidDate(month, day);
    }

    @Override
    public LocalDate of(int year) {
        return LocalDate.of(year, this.month, this.day);
    }

    public String toString() {
        return String.format("%s(%s %s: %02d-%02d)", this.getClass().getSimpleName(), this.getCategory(), this.getName(), this.month, this.day);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedDateHoliday other = (FixedDateHoliday)obj;
        if (this.day != other.day) {
            return false;
        }
        return this.month == other.month;
    }
}

