/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import org.itsallcode.holidays.calculator.logic.Holiday;

public class FloatingHoliday
extends Holiday {
    public static final int LAST_DAY_OF_THE_MONTH = -1;
    private final int offset;
    private final DayOfWeek dayOfWeek;
    private final Direction direction;
    private final int month;
    private final int day;

    public FloatingHoliday(String category, String name, int offset, DayOfWeek dayOfWeek, Direction direction, int month, int day) {
        super(category, name);
        if (offset < 0) {
            throw new IllegalArgumentException("Argument offset must be >= 0, but was " + offset);
        }
        this.offset = offset;
        this.dayOfWeek = dayOfWeek;
        if (day < 1 && day != -1) {
            throw new IllegalArgumentException("Argument day must be > 0 or equal to LAST_DAY_OF_THE_MONTH, but was " + day);
        }
        this.direction = direction;
        this.day = day;
        this.month = month;
        if (this.day > 0) {
            this.ensureValidDate(month, this.day);
        }
    }

    @Override
    public LocalDate of(int year) {
        LocalDate pivotDay = this.pivotDay(year).with(TemporalAdjusters.previousOrSame(this.dayOfWeek));
        int delta = this.direction == Direction.AFTER ? this.offset - 1 : 1 - this.offset;
        return pivotDay.plusDays(7L * (long)delta);
    }

    private LocalDate pivotDay(int year) {
        if (this.direction == Direction.AFTER) {
            return LocalDate.of(year, this.month, this.day).plusDays(6L);
        }
        if (this.day == -1) {
            return LocalDate.of(year, this.month, 1).with(TemporalAdjusters.lastDayOfMonth());
        }
        return LocalDate.of(year, this.month, this.day);
    }

    public String toString() {
        return String.format("%s(%s %s: %d%s %s %s %02d-%s)", this.getClass().getSimpleName(), this.getCategory(), this.getName(), this.offset, this.ordinal(this.offset), this.capitalize(this.dayOfWeek), this.direction.toString().toLowerCase(), this.month, this.dayAsString(this.day));
    }

    private String ordinal(int offset) {
        switch (offset) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private String capitalize(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            return "";
        }
        String str = dayOfWeek.toString();
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private String dayAsString(int day) {
        if (day == -1) {
            return "last-day";
        }
        return String.format("%02d", day);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.day;
        result = 31 * result + (this.dayOfWeek == null ? 0 : this.dayOfWeek.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + this.month;
        result = 31 * result + this.offset;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingHoliday other = (FloatingHoliday)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.dayOfWeek != other.dayOfWeek) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.offset == other.offset;
    }

    public static enum Direction {
        BEFORE,
        AFTER;


        public static Direction parse(String s) {
            return Direction.valueOf(s.toUpperCase());
        }
    }
}

