/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.itsallcode.holidays.calculator.logic.Holiday;

public class HolidaySet {
    final List<Holiday> definitions = new ArrayList<Holiday>();
    private final Set<Integer> years = new HashSet<Integer>();
    private final HashMap<LocalDate, List<Holiday>> holidayInstances = new HashMap();

    public HolidaySet(Collection<Holiday> definitions) {
        this.definitions.addAll(definitions);
    }

    public List<Holiday> instances(LocalDate date) {
        this.cacheHolidays(date.getYear());
        List<Holiday> instances = this.holidayInstances.get(date);
        if (instances == null) {
            return Collections.emptyList();
        }
        return instances;
    }

    private void cacheHolidays(int year) {
        if (this.years.contains(year)) {
            return;
        }
        for (Holiday holiday : this.definitions) {
            LocalDate date = holiday.of(year);
            List entry = this.holidayInstances.computeIfAbsent(date, d -> new ArrayList());
            entry.add(holiday);
        }
        this.years.add(year);
    }

    List<Holiday> getDefinitions() {
        return this.definitions;
    }
}

