/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser;

import java.time.DayOfWeek;
import java.util.HashMap;

public class DayOfWeekParser {
    private final HashMap<String, DayOfWeek> cache = new HashMap();

    public DayOfWeek getDayOfWeek(String prefix) {
        if (this.cache.containsKey(prefix)) {
            return this.cache.get(prefix);
        }
        String upper = "";
        if (prefix != null) {
            upper = prefix.toUpperCase();
        }
        DayOfWeek result = null;
        for (DayOfWeek day : DayOfWeek.values()) {
            if (!day.toString().toUpperCase().startsWith(upper)) continue;
            if (result != null) {
                throw new AmbigueDayOfWeekAbbreviationException(prefix);
            }
            result = day;
        }
        if (result != null) {
            this.cache.put(prefix, result);
        }
        return result;
    }

    public static class AmbigueDayOfWeekAbbreviationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AmbigueDayOfWeekAbbreviationException(String message) {
            super(message);
        }
    }
}

