/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser;

import java.time.DayOfWeek;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.itsallcode.holidays.calculator.logic.EasterBasedHoliday;
import org.itsallcode.holidays.calculator.logic.FixedDateHoliday;
import org.itsallcode.holidays.calculator.logic.FloatingHoliday;
import org.itsallcode.holidays.calculator.logic.Holiday;
import org.itsallcode.holidays.calculator.logic.OrthodoxEasterBasedHoliday;
import org.itsallcode.holidays.calculator.logic.parser.DayOfWeekParser;
import org.itsallcode.holidays.calculator.logic.parser.HolidayMatcher;

public class HolidayParser {
    private static final String CATEGORY_GROUP = "category";
    private static final String TYPE_GROUP = "type";
    private static final String MONTH_GROUP = "month";
    private static final String DAY_GROUP = "day";
    private static final String OFFSET_GROUP = "offset";
    private static final String DIRECTION_GROUP = "direction";
    private static final String DAY_OF_WEEK_GROUP = "dayOfWeek";
    private static final String NAME_GROUP = "name";
    private static final Token MONTH = new Token("month", "0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12");
    private static final Token DAY = new Token("day", "0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31");
    public static final String LAST_DAY = "last-day";
    private static final Token DAY_OR_DEFAULT = new Token("day", HolidayParser.DAY.pattern + "|last-day");
    private static final Token OFFSET = new Token("offset", "[+-]?\\d\\d?");
    private static final Token POSITIVE_OFFSET = new Token("offset", "\\d\\d?");
    private static final Token DIRECTION = new Token("direction", "before|after");
    private static final Token DAY_OF_WEEK = new Token("dayOfWeek", "[a-z]+");
    private static final Token HOLIDAY_NAME = new Token("name", ".*");
    private static final Token CATEGORY = new Token("category", "\\S+");
    private static final Token FIXED = new Token("type", "fixed");
    private static final Token FLOAT = new Token("type", "float");
    private static final Token EASTER = new Token("type", "easter");
    private static final Token ORTHODOX_EASTER = new Token("type", "orthodox-easter");
    private static final String SPACE_REGEXP = "\\s+";
    private static final Pattern FIXED_HOLIDAY = HolidayParser.buildRegexp(CATEGORY, FIXED, MONTH, DAY, HOLIDAY_NAME);
    private static final Pattern FLOATING_HOLIDAY = HolidayParser.buildRegexp(CATEGORY, FLOAT, POSITIVE_OFFSET, DAY_OF_WEEK, DIRECTION, MONTH, DAY_OR_DEFAULT, HOLIDAY_NAME);
    private static final Pattern EASTER_BASED_HOLIDAY = HolidayParser.buildRegexp(CATEGORY, EASTER, OFFSET, HOLIDAY_NAME);
    private static final Pattern ORTHODOX_EASTER_BASED_HOLIDAY = HolidayParser.buildRegexp(CATEGORY, ORTHODOX_EASTER, OFFSET, HOLIDAY_NAME);

    static Pattern buildRegexp(Token ... tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (sb.length() > 0) {
                sb.append(SPACE_REGEXP);
            }
            sb.append(String.format("(?<%s>%s)", token.groupName, token.pattern));
        }
        return Pattern.compile(sb.toString(), 2);
    }

    public Holiday parse(String line) {
        HolidayMatcher[] matchers;
        String trimmed = line.trim();
        for (HolidayMatcher m : matchers = new HolidayMatcher[]{new FixedDateMatcher(), new FloatingDateMatcher(), new EasterBasedMatcher(), new OrthodoxEasterBasedMatcher()}) {
            Holiday holiday = m.createHoliday(trimmed);
            if (holiday == null) continue;
            return holiday;
        }
        return null;
    }

    private static class Token {
        public final String groupName;
        public final String pattern;

        public Token(String groupName, String pattern) {
            this.groupName = groupName;
            this.pattern = pattern;
        }
    }

    private static class OrthodoxEasterBasedMatcher
    extends HolidayMatcher {
        public OrthodoxEasterBasedMatcher() {
            super(ORTHODOX_EASTER_BASED_HOLIDAY);
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            return new OrthodoxEasterBasedHoliday(matcher.group(HolidayParser.CATEGORY_GROUP), matcher.group(HolidayParser.NAME_GROUP), Integer.parseInt(matcher.group(HolidayParser.OFFSET_GROUP)));
        }
    }

    private static class EasterBasedMatcher
    extends HolidayMatcher {
        public EasterBasedMatcher() {
            super(EASTER_BASED_HOLIDAY);
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            return new EasterBasedHoliday(matcher.group(HolidayParser.CATEGORY_GROUP), matcher.group(HolidayParser.NAME_GROUP), Integer.parseInt(matcher.group(HolidayParser.OFFSET_GROUP)));
        }
    }

    private static class FloatingDateMatcher
    extends HolidayMatcher {
        private final DayOfWeekParser dayOfWeekParser = new DayOfWeekParser();

        public FloatingDateMatcher() {
            super(FLOATING_HOLIDAY);
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            DayOfWeek dayOfWeek = this.dayOfWeekParser.getDayOfWeek(matcher.group(HolidayParser.DAY_OF_WEEK_GROUP));
            if (dayOfWeek == null) {
                return null;
            }
            return new FloatingHoliday(matcher.group(HolidayParser.CATEGORY_GROUP), matcher.group(HolidayParser.NAME_GROUP), Integer.parseInt(matcher.group(HolidayParser.OFFSET_GROUP)), dayOfWeek, FloatingHoliday.Direction.parse(matcher.group(HolidayParser.DIRECTION_GROUP)), Integer.parseInt(matcher.group(HolidayParser.MONTH_GROUP)), Integer.parseInt(matcher.group(HolidayParser.DAY_GROUP)));
        }
    }

    private static class FixedDateMatcher
    extends HolidayMatcher {
        public FixedDateMatcher() {
            super(FIXED_HOLIDAY);
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            return new FixedDateHoliday(matcher.group(HolidayParser.CATEGORY_GROUP), matcher.group(HolidayParser.NAME_GROUP), Integer.parseInt(matcher.group(HolidayParser.MONTH_GROUP)), Integer.parseInt(matcher.group(HolidayParser.DAY_GROUP)));
        }
    }
}

