/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.conditions;

import java.time.DayOfWeek;
import java.time.MonthDay;
import java.time.Year;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.itsallcode.holidays.calculator.logic.Formatter;
import org.itsallcode.holidays.calculator.logic.conditions.Condition;

public class DayOfWeekCondition
extends Condition {
    private MonthDay pivot;
    private final Set<DayOfWeek> daysOfWeek = new HashSet<DayOfWeek>();

    public DayOfWeekCondition(DayOfWeek ... daysOfWeek) {
        this((MonthDay)null, daysOfWeek);
    }

    public DayOfWeekCondition(MonthDay pivot, DayOfWeek ... daysOfWeek) {
        this.pivot = pivot;
        this.daysOfWeek.addAll(Arrays.asList(daysOfWeek));
    }

    @Override
    public boolean applies(Year year) {
        return this.daysOfWeek.contains(year.atMonthDay(this.pivot).getDayOfWeek());
    }

    @Override
    public Condition withPivotDate(MonthDay pivot) {
        if (this.pivot == null) {
            this.pivot = pivot;
        }
        return this;
    }

    @Override
    public String toString(String prefix, boolean negated) {
        String days = Arrays.asList(this.daysOfWeek.toArray(new DayOfWeek[0])).stream().sorted(Enum::compareTo).map(Formatter::format).collect(Collectors.joining(","));
        return String.format("%sif %s is%s %s", prefix, Formatter.format(this.pivot), negated ? " not" : "", days);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.daysOfWeek == null ? 0 : this.daysOfWeek.hashCode());
        result = 31 * result + (this.pivot == null ? 0 : this.pivot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayOfWeekCondition other = (DayOfWeekCondition)obj;
        if (this.daysOfWeek == null ? other.daysOfWeek != null : !this.daysOfWeek.equals(other.daysOfWeek)) {
            return false;
        }
        if (this.pivot == null && other.pivot != null) {
            return false;
        }
        return this.pivot.equals(other.pivot);
    }
}

