/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser;

import java.util.HashMap;

public class AbbreviationParser<T extends Enum<T>> {
    private final Class<T> clazz;
    private final HashMap<String, T> cache = new HashMap();

    public AbbreviationParser(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T getEnumFor(String prefix) {
        if (this.cache.containsKey(prefix)) {
            return (T)((Enum)this.cache.get(prefix));
        }
        String upper = "";
        if (prefix != null) {
            upper = prefix.toUpperCase();
        }
        Enum result = null;
        for (Enum value : (Enum[])this.clazz.getEnumConstants()) {
            if (!value.toString().toUpperCase().startsWith(upper)) continue;
            if (result != null) {
                throw new AmbigueAbbreviationException(prefix);
            }
            result = value;
        }
        if (result == null) {
            throw new InvalidAbbreviationException("Could not find any " + this.clazz.getSimpleName() + " for abbreviation \"" + prefix + "\"");
        }
        this.cache.put(prefix, result);
        return (T)result;
    }

    public static class InvalidAbbreviationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidAbbreviationException(String message) {
            super(message);
        }
    }

    public static class AmbigueAbbreviationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AmbigueAbbreviationException(String message) {
            super(message);
        }
    }
}

