/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.variants;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.temporal.TemporalAdjusters;
import org.itsallcode.holidays.calculator.logic.Formatter;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;

public class FloatingHoliday
extends Holiday {
    private final int offset;
    private final DayOfWeek dayOfWeek;
    private final Direction direction;
    private final MonthDay monthDay;
    private final Day dayInterpretation;

    public FloatingHoliday(String category, String name, int offset, DayOfWeek dayOfWeek, Direction direction, int month, Day dayInterpretation) {
        this(category, name, offset, dayOfWeek, direction, MonthDay.of(month, 1), dayInterpretation);
    }

    public FloatingHoliday(String category, String name, int offset, DayOfWeek dayOfWeek, Direction direction, MonthDay monthDay) {
        this(category, name, offset, dayOfWeek, direction, monthDay, Day.AS_SPECIFIED);
    }

    private FloatingHoliday(String category, String name, int offset, DayOfWeek dayOfWeek, Direction direction, MonthDay monthDay, Day dayInterpretation) {
        super(category, name);
        if (offset < 0) {
            throw new IllegalArgumentException("Argument offset must be >= 0, but was " + offset);
        }
        this.offset = offset;
        this.dayOfWeek = dayOfWeek;
        this.direction = direction;
        this.dayInterpretation = dayInterpretation;
        this.monthDay = monthDay;
    }

    @Override
    public LocalDate of(int year) {
        LocalDate pivotDay = this.pivotDay(year).with(TemporalAdjusters.previousOrSame(this.dayOfWeek));
        int delta = this.direction == Direction.AFTER ? this.offset - 1 : 1 - this.offset;
        return pivotDay.plusDays(7L * (long)delta + (long)this.offsetInDays);
    }

    private LocalDate pivotDay(int year) {
        if (this.direction == Direction.AFTER) {
            return this.monthDay.atYear(year).plusDays(6L);
        }
        if (this.dayInterpretation == Day.LAST) {
            return this.monthDay.atYear(year).with(TemporalAdjusters.lastDayOfMonth());
        }
        return this.monthDay.atYear(year);
    }

    @Override
    public String toString() {
        return String.format("%s(%s %s: %s%s %s %s %s)", this.getClass().getSimpleName(), this.getCategory(), this.getName(), Formatter.offsetWithoutZero(this.offsetInDays), Formatter.ordinal(this.offset), Formatter.formatLong(this.dayOfWeek), this.direction.toString().toLowerCase(), Formatter.format(this.monthDay, this.dayInterpretation));
    }

    @Override
    public MonthDay getMonthDay() {
        return this.monthDay;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dayInterpretation == null ? 0 : this.dayInterpretation.hashCode());
        result = 31 * result + (this.dayOfWeek == null ? 0 : this.dayOfWeek.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.monthDay == null ? 0 : this.monthDay.hashCode());
        result = 31 * result + this.offset;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingHoliday other = (FloatingHoliday)obj;
        if (this.dayInterpretation != other.dayInterpretation) {
            return false;
        }
        if (this.dayOfWeek != other.dayOfWeek) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (this.monthDay == null ? other.monthDay != null : !this.monthDay.equals(other.monthDay)) {
            return false;
        }
        return this.offset == other.offset;
    }

    public static enum Day {
        AS_SPECIFIED,
        FIRST,
        LAST;

    }

    public static enum Direction {
        BEFORE,
        AFTER;


        public static Direction parse(String s) {
            return Direction.valueOf(s.toUpperCase());
        }
    }
}

