/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api;

import org.itsallcode.openfasttrace.api.core.Newline;
import org.itsallcode.openfasttrace.api.report.ReportVerbosity;

public class ReportSettings {
    private final ReportVerbosity verbosity;
    private final boolean showOrigin;
    private final String outputFormat;
    private final Newline newline;

    private ReportSettings(Builder builder) {
        this.verbosity = builder.verbosity;
        this.showOrigin = builder.showOrigin;
        this.outputFormat = builder.outputFormat;
        this.newline = builder.newline;
    }

    public ReportVerbosity getReportVerbosity() {
        return this.verbosity;
    }

    public boolean showOrigin() {
        return this.showOrigin;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public Newline getNewline() {
        return this.newline;
    }

    public static ReportSettings createDefault() {
        return ReportSettings.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Newline newline = Newline.UNIX;
        private String outputFormat = "plain";
        private boolean showOrigin = false;
        private ReportVerbosity verbosity = ReportVerbosity.FAILURE_DETAILS;

        private Builder() {
        }

        public ReportSettings build() {
            return new ReportSettings(this);
        }

        public Builder verbosity(ReportVerbosity verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public Builder showOrigin(boolean showOrigin) {
            this.showOrigin = showOrigin;
            return this;
        }

        public Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder newline(Newline newline) {
            this.newline = newline;
            return this;
        }
    }
}

