/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

public enum LinkStatus {
    COVERS(" ", "covers"),
    PREDATED(">", "predated"),
    OUTDATED("<", "outdated"),
    AMBIGUOUS("?", "ambiguous"),
    UNWANTED("+", "unwanted"),
    ORPHANED("/", "orphaned"),
    COVERED_SHALLOW(" ", "covered shallow"),
    COVERED_UNWANTED("+", "unwanted coverage"),
    COVERED_PREDATED(">", "predated coverage"),
    COVERED_OUTDATED("<", "outdated coverage"),
    DUPLICATE("?", "duplicate");

    private final String shortTag;
    private final String text;

    private LinkStatus(String shortTag, String text) {
        this.shortTag = shortTag;
        this.text = text;
    }

    public boolean isBad() {
        return this != COVERS && this != COVERED_SHALLOW;
    }

    public boolean isOutgoing() {
        return this == COVERS || this.isBadOutgoing();
    }

    public boolean isBadOutgoing() {
        return this == PREDATED || this == OUTDATED || this == AMBIGUOUS || this == UNWANTED || this == ORPHANED;
    }

    public boolean isIncoming() {
        return this == COVERED_SHALLOW || this.isBadIncoming();
    }

    public boolean isBadIncoming() {
        return this == COVERED_UNWANTED || this == COVERED_PREDATED || this == COVERED_OUTDATED;
    }

    public boolean isDuplicate() {
        return this == DUPLICATE;
    }

    public String getShortTag() {
        return this.shortTag;
    }

    public String toString() {
        return this.text;
    }
}

