/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.itsallcode.openfasttrace.api.core.ItemStatus;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;

public class SpecificationItem {
    private final SpecificationItemId id;
    private final String title;
    private final String description;
    private final String rationale;
    private final String comment;
    private final Location location;
    private final ItemStatus status;
    private final List<SpecificationItemId> coveredIds;
    private final List<SpecificationItemId> dependOnIds;
    private final List<String> needsArtifactTypes;
    private final List<String> tags;
    private final boolean forwards;

    private SpecificationItem(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.rationale = builder.rationale;
        this.comment = builder.comment;
        this.location = builder.location;
        this.status = builder.status;
        this.coveredIds = builder.coveredIds;
        this.dependOnIds = builder.dependOnIds;
        this.needsArtifactTypes = builder.neededArtifactTypes;
        this.tags = builder.tags;
        this.forwards = builder.forwards;
    }

    public SpecificationItemId getId() {
        return this.id;
    }

    public String getArtifactType() {
        return this.id.getArtifactType();
    }

    public String getName() {
        return this.id.getName();
    }

    public int getRevision() {
        return this.id.getRevision();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRationale() {
        return this.rationale;
    }

    public String getComment() {
        return this.comment;
    }

    public List<SpecificationItemId> getCoveredIds() {
        return this.coveredIds;
    }

    public List<SpecificationItemId> getDependOnIds() {
        return this.dependOnIds;
    }

    public List<String> getNeedsArtifactTypes() {
        return this.needsArtifactTypes;
    }

    public boolean needsCoverageByArtifactType(String artifactType) {
        return this.needsArtifactTypes.contains(artifactType);
    }

    public boolean needsCoverage() {
        return !this.needsArtifactTypes.isEmpty();
    }

    public Location getLocation() {
        return this.location;
    }

    public ItemStatus getStatus() {
        return this.status;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean isForwarding() {
        return this.forwards;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.coveredIds == null ? 0 : this.coveredIds.hashCode());
        result = 31 * result + (this.dependOnIds == null ? 0 : this.dependOnIds.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.forwards ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.needsArtifactTypes == null ? 0 : this.needsArtifactTypes.hashCode());
        result = 31 * result + (this.rationale == null ? 0 : this.rationale.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpecificationItem)) {
            return false;
        }
        SpecificationItem other = (SpecificationItem)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.coveredIds == null ? other.coveredIds != null : !this.coveredIds.equals(other.coveredIds)) {
            return false;
        }
        if (this.dependOnIds == null ? other.dependOnIds != null : !this.dependOnIds.equals(other.dependOnIds)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.forwards != other.forwards) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.needsArtifactTypes == null ? other.needsArtifactTypes != null : !this.needsArtifactTypes.equals(other.needsArtifactTypes)) {
            return false;
        }
        if (this.rationale == null ? other.rationale != null : !this.rationale.equals(other.rationale)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SpecificationItemId id = null;
        private String title = "";
        private String description = "";
        private String rationale = "";
        private String comment = "";
        private ItemStatus status = ItemStatus.APPROVED;
        private Location location = null;
        private final List<SpecificationItemId> coveredIds = new ArrayList<SpecificationItemId>();
        private final List<SpecificationItemId> dependOnIds = new ArrayList<SpecificationItemId>();
        private final List<String> neededArtifactTypes = new ArrayList<String>();
        private final List<String> tags = new ArrayList<String>();
        private boolean forwards;

        private Builder() {
        }

        public Builder id(SpecificationItemId id) {
            this.id = id;
            return this;
        }

        public Builder id(String artifactType, String name, int revision) {
            this.id = new SpecificationItemId.Builder().artifactType(artifactType).name(name).revision(revision).build();
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder rationale(String rationale) {
            this.rationale = rationale;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder status(ItemStatus status) {
            this.status = status;
            return this;
        }

        public Builder addCoveredId(SpecificationItemId coveredId) {
            this.coveredIds.add(coveredId);
            return this;
        }

        public Builder addCoveredId(String artifactType, String name, int revision) {
            this.coveredIds.add(new SpecificationItemId.Builder().artifactType(artifactType).name(name).revision(revision).build());
            return this;
        }

        public Builder addDependOnId(SpecificationItemId dependOnId) {
            this.dependOnIds.add(dependOnId);
            return this;
        }

        public Builder addDependOnId(String artifactType, String name, int revision) {
            this.dependOnIds.add(new SpecificationItemId.Builder().artifactType(artifactType).name(name).revision(revision).build());
            return this;
        }

        public Builder addNeedsArtifactType(String neededArtifactType) {
            this.neededArtifactTypes.add(neededArtifactType);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder location(String path, Integer line) {
            Objects.requireNonNull(path, "path");
            Objects.requireNonNull(line, "line");
            return this.location(Location.create(path, line));
        }

        public SpecificationItem build() {
            if (this.id == null) {
                throw new IllegalStateException("No id given");
            }
            return new SpecificationItem(this);
        }

        public Builder forwards(boolean forwards) {
            this.forwards = forwards;
            return this;
        }
    }
}

