/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecificationItemId
implements Comparable<SpecificationItemId> {
    private static final Logger LOG = Logger.getLogger(SpecificationItemId.class.getName());
    public static final String UNKNOWN_ARTIFACT_TYPE = "unknown";
    public static final String ITEM_REVISION_PATTERN = "(\\d+)";
    public static final String ITEM_NAME_PATTERN = "(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*)";
    private static final String LEGACY_ID_NAME = "(\\p{Alpha}+)(?:~\\p{Alpha}+)?:(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*)";
    public static final String ARTIFACT_TYPE_SEPARATOR = "~";
    public static final String REVISION_SEPARATOR = "~";
    public static final int REVISION_WILDCARD = Integer.MIN_VALUE;
    private static final String ID = "(\\p{Alpha}+)~(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*)~(\\d+)";
    private static final String LEGACY_ID = "(\\p{Alpha}+)(?:~\\p{Alpha}+)?:(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*), *v(\\d+)";
    private static final int ARTIFACT_TYPE_MATCHING_GROUP = 1;
    private static final int NAME_MATCHING_GROUP = 2;
    private static final int REVISION_MATCHING_GROUP = 3;
    public static final Pattern ID_PATTERN = Pattern.compile("(\\p{Alpha}+)~(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*)~(\\d+)");
    public static final Pattern LEGACY_NAME_PATTERN = Pattern.compile("(\\p{Alpha}+)(?:~\\p{Alpha}+)?:(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*)");
    public static final Pattern LEGACY_ID_PATTERN = Pattern.compile("(\\p{Alpha}+)(?:~\\p{Alpha}+)?:(\\p{Alpha}[\\w-]*(?:\\.\\p{Alpha}[\\w-]*)*), *v(\\d+)");
    private final String name;
    private final int revision;
    private final String artifactType;

    protected SpecificationItemId(String name, String artifactType, int revision) {
        this.name = name;
        this.artifactType = artifactType;
        this.revision = revision;
    }

    public String getName() {
        return this.name;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactType == null ? 0 : this.artifactType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.revision;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpecificationItemId)) {
            return false;
        }
        SpecificationItemId other = (SpecificationItemId)obj;
        if (this.artifactType == null ? other.artifactType != null : !this.artifactType.equals(other.artifactType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return other.revision == Integer.MIN_VALUE || this.revision == other.revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.artifactType).append("~").append(this.name).append("~").append(this.revision);
        return builder.toString();
    }

    public SpecificationItemId toRevisionWildcard() {
        return new Builder().artifactType(this.artifactType).name(this.name).revisionWildcard().build();
    }

    public static SpecificationItemId parseId(String idText) {
        return new Builder(idText).build();
    }

    public static SpecificationItemId createId(String artifactType, String name, int revision) {
        return new Builder().artifactType(artifactType).name(name).revision(revision).build();
    }

    public static SpecificationItemId createId(String artifactType, String name) {
        return new Builder().artifactType(artifactType).name(name).revisionWildcard().build();
    }

    @Override
    public int compareTo(SpecificationItemId other) {
        int compared = this.getArtifactType().compareTo(other.getArtifactType());
        if (compared == 0 && (compared = this.getName().compareTo(other.getName())) == 0) {
            if (this.getRevision() > other.getRevision()) {
                compared = 1;
            } else if (this.getRevision() < other.getRevision()) {
                compared = -1;
            }
        }
        return compared;
    }

    public static class Builder {
        private final String id;
        private String artifactType;
        private String name;
        private int revision;

        public Builder(String id) {
            this.id = id;
        }

        public Builder() {
            this(null);
        }

        public Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder revision(int revision) {
            this.revision = revision;
            return this;
        }

        public Builder revisionWildcard() {
            this.revision = Integer.MIN_VALUE;
            return this;
        }

        public SpecificationItemId build() {
            if (this.id == null) {
                this.validateFields();
                this.cleanUpLegacyIds();
            } else {
                this.parseId();
            }
            return new SpecificationItemId(this.name, this.artifactType, this.revision);
        }

        private void validateFields() {
            if (this.name == null) {
                throw new IllegalStateException("Name is missing");
            }
        }

        private void cleanUpLegacyIds() {
            if (this.artifactType == null || this.artifactType.isEmpty()) {
                this.inferArtifactType();
            }
            this.removeSuperfluousArtifactPrefix();
        }

        private void inferArtifactType() {
            Matcher matcher = LEGACY_NAME_PATTERN.matcher(this.name);
            if (matcher.matches()) {
                this.artifactType = matcher.group(1);
            } else {
                LOG.warning(() -> "Name '" + this.name + "' does not match legacy name pattern '" + LEGACY_NAME_PATTERN + "': using artifact type 'unknown'.");
                this.artifactType = SpecificationItemId.UNKNOWN_ARTIFACT_TYPE;
            }
        }

        private void removeSuperfluousArtifactPrefix() {
            Matcher matcher = LEGACY_NAME_PATTERN.matcher(this.name);
            if (matcher.matches()) {
                this.name = matcher.group(2);
            }
        }

        private void parseId() {
            Matcher matcher = ID_PATTERN.matcher(this.id);
            if (matcher.matches()) {
                this.setIdPartsFromMatches(matcher);
            } else {
                Matcher legacyMatcher = LEGACY_ID_PATTERN.matcher(this.id);
                if (legacyMatcher.matches()) {
                    this.setIdPartsFromMatches(legacyMatcher);
                } else {
                    throw new IllegalStateException("String \"" + this.id + "\" cannot be parsed to a specification item ID");
                }
            }
        }

        private void setIdPartsFromMatches(Matcher matcher) {
            this.artifactType = matcher.group(1);
            this.name = matcher.group(2);
            this.parseRevision(matcher.group(3));
        }

        private void parseRevision(String text) {
            try {
                this.revision = Integer.parseInt(text);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Error parsing version number from specification item ID: \"" + this.id + "\"", exception);
            }
        }
    }
}

