/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.importer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.itsallcode.openfasttrace.api.FilterSettings;
import org.itsallcode.openfasttrace.api.core.ItemStatus;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.SpecificationItem;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;

public class SpecificationListBuilder
implements ImportEventListener {
    private final FilterSettings filterSettings;
    private final List<SpecificationItem> items = new LinkedList<SpecificationItem>();
    private SpecificationItem.Builder itemBuilder = null;
    private SpecificationItemId id = null;
    private StringBuilder description = new StringBuilder();
    private StringBuilder rationale = new StringBuilder();
    private StringBuilder comment = new StringBuilder();
    private Location location;

    private SpecificationListBuilder(FilterSettings filterSettings) {
        this.filterSettings = filterSettings;
    }

    public static SpecificationListBuilder create() {
        return new SpecificationListBuilder(new FilterSettings.Builder().build());
    }

    public static SpecificationListBuilder createWithFilter(FilterSettings filterSettings) {
        return new SpecificationListBuilder(filterSettings);
    }

    @Override
    public void beginSpecificationItem() {
        this.itemBuilder = SpecificationItem.builder();
    }

    private void resetState() {
        this.itemBuilder = null;
        this.description = new StringBuilder();
        this.rationale = new StringBuilder();
        this.comment = new StringBuilder();
        this.location = null;
        this.id = null;
    }

    @Override
    public void setId(SpecificationItemId id) {
        this.id = id;
    }

    @Override
    public void setStatus(ItemStatus status) {
        this.itemBuilder.status(status);
    }

    @Override
    public void addCoveredId(SpecificationItemId id) {
        if (this.isAcceptedArtifactType(id.getArtifactType())) {
            this.itemBuilder.addCoveredId(id);
        }
    }

    @Override
    public void appendDescription(String fragment) {
        this.description.append(fragment);
    }

    @Override
    public void appendRationale(String fragment) {
        this.rationale.append(fragment);
    }

    @Override
    public void appendComment(String fragment) {
        this.comment.append(fragment);
    }

    @Override
    public void addDependsOnId(SpecificationItemId id) {
        if (this.isAcceptedArtifactType(id.getArtifactType())) {
            this.itemBuilder.addDependOnId(id);
        }
    }

    @Override
    public void addNeededArtifactType(String artifactType) {
        if (this.isAcceptedArtifactType(artifactType)) {
            this.itemBuilder.addNeedsArtifactType(artifactType);
        }
    }

    @Override
    public void addTag(String tag) {
        this.itemBuilder.addTag(tag);
    }

    public List<SpecificationItem> build() {
        this.endSpecificationItem();
        return this.items;
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void setTitle(String title) {
        this.itemBuilder.title(title);
    }

    @Override
    public void setLocation(String path, int line) {
        this.setLocation(Location.create(path, line));
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void endSpecificationItem() {
        SpecificationItem item;
        if (this.itemBuilder != null && this.isAccepted(item = this.createNewSpecificationItem())) {
            this.addNewItemToList(item);
        }
        this.resetState();
    }

    private SpecificationItem createNewSpecificationItem() {
        return this.itemBuilder.id(this.id).description(this.description.toString()).rationale(this.rationale.toString()).comment(this.comment.toString()).location(this.location).build();
    }

    private boolean isAccepted(SpecificationItem item) {
        return this.isAcceptedArtifactType(item.getArtifactType()) && this.matchesTagsCriteria(item.getTags());
    }

    private boolean matchesTagsCriteria(List<String> tags) {
        return !this.filterSettings.isTagCriteriaSet() || this.filterSettings.withoutTags() && tags.isEmpty() || !Collections.disjoint(this.filterSettings.getTags(), tags);
    }

    private boolean isAcceptedArtifactType(String artifactType) {
        return !this.filterSettings.isArtifactTypeCriteriaSet() || this.filterSettings.getArtifactTypes().contains(artifactType);
    }

    private void addNewItemToList(SpecificationItem item) {
        this.items.add(item);
    }

    @Override
    public void setForwards(boolean forwards) {
        this.itemBuilder.forwards(forwards);
    }
}

