/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.itsallcode.openfasttrace.api.core.DeepCoverageStatus;
import org.itsallcode.openfasttrace.api.core.ItemStatus;
import org.itsallcode.openfasttrace.api.core.LinkStatus;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.SpecificationItem;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.core.TracedLink;

public class LinkedSpecificationItem {
    private final SpecificationItem item;
    private final Map<LinkStatus, List<LinkedSpecificationItem>> links = new EnumMap<LinkStatus, List<LinkedSpecificationItem>>(LinkStatus.class);
    private final Set<String> coveredArtifactTypes = new HashSet<String>();
    private final Set<String> coveredArtifactTypesFromApprovedItems = new HashSet<String>();
    private final Set<String> overCoveredArtifactTypes = new HashSet<String>();

    public LinkedSpecificationItem(SpecificationItem item) {
        this.item = item;
    }

    public SpecificationItemId getId() {
        return this.item.getId();
    }

    public String getTitle() {
        return this.item.getTitle();
    }

    public String getTitleWithFallback() {
        String name;
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            return title;
        }
        SpecificationItemId id = this.getId();
        if (id != null && (name = id.getName()) != null && !name.isEmpty()) {
            return name;
        }
        return "???";
    }

    public ItemStatus getStatus() {
        return this.item.getStatus();
    }

    public String getDescription() {
        return this.item.getDescription();
    }

    public Location getLocation() {
        return this.item.getLocation();
    }

    public List<String> getTags() {
        return this.item.getTags();
    }

    public SpecificationItem getItem() {
        return this.item;
    }

    public void addLinkToItemWithStatus(LinkedSpecificationItem item, LinkStatus status) {
        this.links.computeIfAbsent(status, key -> new ArrayList());
        this.links.get((Object)status).add(item);
        switch (status) {
            case COVERED_SHALLOW: {
                this.cacheApprovedCoveredArtifactType(item);
                this.coveredArtifactTypes.add(item.getArtifactType());
                this.addMyItemIdToCoveringItem(item);
                break;
            }
            case COVERED_UNWANTED: {
                this.cacheOverCoveredArtifactType(item);
                this.addMyItemIdToCoveringItem(item);
                break;
            }
            case COVERED_OUTDATED: 
            case COVERED_PREDATED: {
                this.addMyItemIdToCoveringItem(item);
                break;
            }
        }
    }

    private void addMyItemIdToCoveringItem(LinkedSpecificationItem coveringItem) {
        if (coveringItem.getItem().getCoveredIds() != null && !coveringItem.getItem().getCoveredIds().contains(this.getId())) {
            coveringItem.getItem().getCoveredIds().add(this.getId());
        }
    }

    private void cacheApprovedCoveredArtifactType(LinkedSpecificationItem coveringItem) {
        if (coveringItem.isApproved()) {
            this.coveredArtifactTypesFromApprovedItems.add(coveringItem.getArtifactType());
        }
    }

    private void cacheOverCoveredArtifactType(LinkedSpecificationItem overcoveringItem) {
        if (overcoveringItem.getArtifactType() != null) {
            this.overCoveredArtifactTypes.add(overcoveringItem.getArtifactType());
        }
    }

    public Map<LinkStatus, List<LinkedSpecificationItem>> getLinks() {
        return this.links;
    }

    public List<LinkedSpecificationItem> getLinksByStatus(LinkStatus status) {
        List<LinkedSpecificationItem> linksWithStatus = this.links.get((Object)status);
        return linksWithStatus == null ? Collections.emptyList() : linksWithStatus;
    }

    public List<TracedLink> getTracedLinks() {
        ArrayList<TracedLink> tracedLinks = new ArrayList<TracedLink>();
        for (Map.Entry<LinkStatus, List<LinkedSpecificationItem>> entry : this.links.entrySet()) {
            for (LinkedSpecificationItem other : entry.getValue()) {
                tracedLinks.add(new TracedLink(other, entry.getKey()));
            }
        }
        return tracedLinks;
    }

    public List<SpecificationItemId> getCoveredIds() {
        return List.copyOf(this.getItem().getCoveredIds());
    }

    public List<String> getNeedsArtifactTypes() {
        return this.getItem().getNeedsArtifactTypes();
    }

    public Set<String> getCoveredArtifactTypes() {
        return this.coveredArtifactTypes;
    }

    public Set<String> getCoveredApprovedArtifactTypes() {
        return this.coveredArtifactTypesFromApprovedItems;
    }

    public Set<String> getOverCoveredArtifactTypes() {
        return this.overCoveredArtifactTypes;
    }

    public List<String> getUncoveredArtifactTypes() {
        ArrayList<String> uncovered = new ArrayList<String>(this.getNeedsArtifactTypes());
        uncovered.removeAll(this.getCoveredArtifactTypes());
        return uncovered;
    }

    public List<String> getUncoveredApprovedArtifactTypes() {
        ArrayList<String> uncovered = new ArrayList<String>(this.getNeedsArtifactTypes());
        uncovered.removeAll(this.getCoveredApprovedArtifactTypes());
        return uncovered;
    }

    public boolean isCoveredShallow() {
        return this.areAllArtifactTypesCovered();
    }

    public boolean isCoveredShallowWithApprovedItems() {
        return this.isApproved() && this.areAllCoveredArtifactTypesApproved();
    }

    public DeepCoverageStatus getDeepCoverageStatus() {
        return this.getDeepCoverageStatusEndRecursionStartingAt(this.getId(), DeepCoverageStatus.COVERED, false);
    }

    public DeepCoverageStatus getDeepCoverageStatusOnlyAcceptApprovedItems() {
        return this.getDeepCoverageStatusEndRecursionStartingAt(this.getId(), DeepCoverageStatus.COVERED, true);
    }

    private DeepCoverageStatus getDeepCoverageStatusEndRecursionStartingAt(SpecificationItemId startId, DeepCoverageStatus worstStatusSeen, boolean onlyAcceptApprovedItemStatus) {
        DeepCoverageStatus status = worstStatusSeen;
        status = this.adjustDeepCoverageStatusIfApprovedRequired(onlyAcceptApprovedItemStatus, status);
        for (LinkedSpecificationItem incomingItem : this.getIncomingItems()) {
            if (incomingItem.getId().equals(startId)) {
                return DeepCoverageStatus.CYCLE;
            }
            DeepCoverageStatus otherStatus = incomingItem.getDeepCoverageStatusEndRecursionStartingAt(startId, status, onlyAcceptApprovedItemStatus);
            if (otherStatus == DeepCoverageStatus.CYCLE) {
                return DeepCoverageStatus.CYCLE;
            }
            status = DeepCoverageStatus.getWorst(status, otherStatus);
        }
        if (status == DeepCoverageStatus.COVERED && !this.isCoveredShallow()) {
            return DeepCoverageStatus.UNCOVERED;
        }
        return status;
    }

    private DeepCoverageStatus adjustDeepCoverageStatusIfApprovedRequired(boolean onlyAcceptApprovedItemStatus, DeepCoverageStatus deepCoveredStatus) {
        return onlyAcceptApprovedItemStatus && deepCoveredStatus == DeepCoverageStatus.COVERED && !this.isApproved() ? DeepCoverageStatus.UNCOVERED : deepCoveredStatus;
    }

    private List<LinkedSpecificationItem> getIncomingItems() {
        return this.links.entrySet().stream().filter(entry -> ((LinkStatus)((Object)((Object)entry.getKey()))).isIncoming()).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
    }

    public boolean isDefect() {
        return this.hasDuplicates() || this.getStatus() != ItemStatus.REJECTED && (this.hasBadLinks() || this.getDeepCoverageStatus() != DeepCoverageStatus.COVERED);
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    private boolean hasBadLinks() {
        for (LinkStatus status : this.links.keySet()) {
            if (!status.isBad()) continue;
            return true;
        }
        return false;
    }

    private boolean areAllArtifactTypesCovered() {
        return this.getCoveredArtifactTypes().containsAll(this.getNeedsArtifactTypes());
    }

    private boolean areAllCoveredArtifactTypesApproved() {
        return this.getCoveredApprovedArtifactTypes().containsAll(this.getNeedsArtifactTypes());
    }

    private boolean isApproved() {
        return this.getStatus() == ItemStatus.APPROVED;
    }

    public int countOutgoingLinks() {
        return this.countLinksWithPredicate(entry -> ((LinkStatus)((Object)((Object)entry.getKey()))).isOutgoing());
    }

    private int countLinksWithPredicate(Predicate<Map.Entry<LinkStatus, List<LinkedSpecificationItem>>> predicate) {
        return this.links.entrySet().stream().filter(predicate).mapToInt(entry -> ((List)entry.getValue()).size()).sum();
    }

    public int countOutgoingBadLinks() {
        return this.countLinksWithPredicate(entry -> ((LinkStatus)((Object)((Object)entry.getKey()))).isBadOutgoing());
    }

    public int countIncomingLinks() {
        return this.countLinksWithPredicate(entry -> ((LinkStatus)((Object)((Object)entry.getKey()))).isIncoming());
    }

    public int countIncomingBadLinks() {
        return this.countLinksWithPredicate(entry -> ((LinkStatus)((Object)((Object)entry.getKey()))).isBadIncoming());
    }

    public int countDuplicateLinks() {
        return this.countLinksWithPredicate(entry -> ((LinkStatus)((Object)((Object)entry.getKey()))).isDuplicate());
    }

    public boolean hasDuplicates() {
        return this.countDuplicateLinks() != 0;
    }

    public String getArtifactType() {
        return this.item.getArtifactType();
    }

    public String getName() {
        return this.item.getName();
    }

    public int getRevision() {
        return this.item.getRevision();
    }
}

