/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.importer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.api.importer.Importer;
import org.itsallcode.openfasttrace.api.importer.ImporterException;
import org.itsallcode.openfasttrace.api.importer.ImporterFactory;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;

public abstract class RegexMatchingImporterFactory
extends ImporterFactory {
    private static final Logger LOG = Logger.getLogger(RegexMatchingImporterFactory.class.getName());
    private final Set<Pattern> supportedFilenamePatterns;

    protected RegexMatchingImporterFactory(String ... supportedFilenamePatterns) {
        this(Arrays.asList(supportedFilenamePatterns));
    }

    protected RegexMatchingImporterFactory(Collection<String> supportedFilenamePatterns) {
        this.supportedFilenamePatterns = supportedFilenamePatterns.stream().map(Pattern::compile).collect(Collectors.toSet());
    }

    @Override
    public boolean supportsFile(InputFile file) {
        String fileName = file.getPath();
        for (Pattern pattern : this.supportedFilenamePatterns) {
            if (!pattern.matcher(fileName).matches()) continue;
            LOG.finest(() -> "Filename '" + fileName + "' matches '" + pattern + "': supported  by " + this.getClass().getName());
            return true;
        }
        LOG.finest(() -> "Filename '" + fileName + "' does not match any regexp of " + this.supportedFilenamePatterns + ": not supported by " + this.getClass().getName());
        return false;
    }

    @Override
    public Importer createImporter(InputFile file, ImportEventListener listener) {
        if (!this.supportsFile(file)) {
            throw new ImporterException("File '" + file + "' not supported for import. Supported file name patterns: " + this.supportedFilenamePatterns);
        }
        LOG.finest(() -> "Creating importer for file " + file);
        return () -> this.runImporter(file, listener);
    }

    private void runImporter(InputFile file, ImportEventListener listener) {
        Importer importer = this.createImporter(file, listener);
        importer.runImport();
    }
}

