/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.core;

import java.util.regex.Pattern;

public enum Newline {
    UNIX("\n"),
    WINDOWS("\r\n"),
    OLDMAC("\r");

    private static final String ANY_NEWLINE_REG_EX = "\\r\\n|\\r|\\n";
    private static final Pattern ANY_NEWLINE_PATTERN;
    private final String representation;

    private Newline(String representation) {
        this.representation = representation;
    }

    public String toString() {
        return this.representation;
    }

    public static Newline fromRepresentation(String representation) {
        switch (representation) {
            case "\n": {
                return UNIX;
            }
            case "\r\n": {
                return WINDOWS;
            }
            case "\r": {
                return OLDMAC;
            }
        }
        throw new IllegalArgumentException("Line separator not supported: '" + representation + "'");
    }

    public static String anyNewlineReqEx() {
        return ANY_NEWLINE_REG_EX;
    }

    public static Pattern anyNewlinePattern() {
        return ANY_NEWLINE_PATTERN;
    }

    static {
        ANY_NEWLINE_PATTERN = Pattern.compile(ANY_NEWLINE_REG_EX);
    }
}

