/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.importer;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.itsallcode.openfasttrace.api.FilterSettings;
import org.itsallcode.openfasttrace.api.importer.tag.config.PathConfig;

public class ImportSettings {
    private final List<Path> inputs;
    private final FilterSettings filter;
    private final List<PathConfig> pathConfigs;

    private ImportSettings(Builder builder) {
        this.inputs = builder.inputs;
        this.filter = builder.filter;
        this.pathConfigs = builder.pathConfigs;
    }

    public List<Path> getInputs() {
        return this.inputs;
    }

    public FilterSettings getFilters() {
        return this.filter;
    }

    public List<PathConfig> getPathConfigs() {
        return this.pathConfigs;
    }

    public static ImportSettings createDefault() {
        return ImportSettings.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Path> inputs = new ArrayList<Path>();
        private FilterSettings filter = FilterSettings.createAllowingEverything();
        private List<PathConfig> pathConfigs = new ArrayList<PathConfig>();

        private Builder() {
        }

        public Builder addInputs(List<Path> inputs) {
            this.inputs.addAll(inputs);
            return this;
        }

        public Builder addInputs(Path ... inputs) {
            for (Path input : inputs) {
                this.inputs.add(input);
            }
            return this;
        }

        public Builder filter(FilterSettings filter) {
            this.filter = filter;
            return this;
        }

        public Builder pathConfigs(List<PathConfig> pathConfigs) {
            this.pathConfigs = pathConfigs;
            return this;
        }

        public ImportSettings build() {
            return new ImportSettings(this);
        }
    }
}

