/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.api.importer.tag.config;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.api.importer.tag.config.DescribedPathMatcher;

public class PathConfig {
    private static final Logger LOG = Logger.getLogger(PathConfig.class.getName());
    private final DescribedPathMatcher pathMatcher;
    private final String coveredItemNamePrefix;
    private final String coveredItemArtifactType;
    private final String tagArtifactType;

    private PathConfig(Builder builder) {
        this.pathMatcher = Objects.requireNonNull(builder.pathMatcher, "pathMatcher");
        this.coveredItemNamePrefix = builder.coveredItemNamePrefix;
        this.coveredItemArtifactType = Objects.requireNonNull(builder.coveredItemArtifactType, "coveredItemArtifactType");
        this.tagArtifactType = Objects.requireNonNull(builder.tagArtifactType, "tagArtifactType");
    }

    public String getDescription() {
        return this.pathMatcher.getDescription();
    }

    public boolean matches(InputFile file) {
        boolean matches = this.pathMatcher.matches(file);
        LOG.finest(() -> "File " + file + " matches " + this.pathMatcher + " = " + matches);
        return matches;
    }

    public String getTagArtifactType() {
        return this.tagArtifactType;
    }

    public String getCoveredItemArtifactType() {
        return this.coveredItemArtifactType;
    }

    public String getCoveredItemNamePrefix() {
        return this.coveredItemNamePrefix;
    }

    public String toString() {
        return "PathConfig [pathMatcher='" + this.pathMatcher.getDescription() + "', coveredItemNamePrefix=" + this.coveredItemNamePrefix + ", coveredItemArtifactType=" + this.coveredItemArtifactType + ", tagArtifactType=" + this.tagArtifactType + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DescribedPathMatcher pathMatcher;
        private String coveredItemNamePrefix;
        private String coveredItemArtifactType;
        private String tagArtifactType;

        private Builder() {
        }

        public Builder patternPathMatcher(String pattern) {
            this.pathMatcher = DescribedPathMatcher.createPatternMatcher(pattern);
            return this;
        }

        public Builder pathListMatcher(List<Path> paths) {
            this.pathMatcher = DescribedPathMatcher.createPathListMatcher(paths);
            return this;
        }

        public Builder coveredItemNamePrefix(String coveredItemNamePrefix) {
            this.coveredItemNamePrefix = coveredItemNamePrefix;
            return this;
        }

        public Builder coveredItemArtifactType(String coveredItemArtifactType) {
            this.coveredItemArtifactType = coveredItemArtifactType;
            return this;
        }

        public Builder tagArtifactType(String tagArtifactType) {
            this.tagArtifactType = tagArtifactType;
            return this;
        }

        public PathConfig build() {
            return new PathConfig(this);
        }
    }
}

