/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.exporter.common;

import java.util.Deque;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.itsallcode.openfasttrace.exporter.common.DelegatingXMLStreamWriter;

public class IndentingXMLStreamWriter
extends DelegatingXMLStreamWriter
implements AutoCloseable {
    private static final String NEWLINE = "\n";
    private static final String INDENTATION = "  ";
    private final Deque<State> stateStack = new LinkedList<State>();
    private State state = State.SEEN_NOTHING;
    private int depth = 0;

    public IndentingXMLStreamWriter(XMLStreamWriter writer) {
        super(writer);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        super.writeStartDocument();
        super.writeCharacters(NEWLINE);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        super.writeStartDocument(version);
        super.writeCharacters(NEWLINE);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        super.writeStartDocument(encoding, version);
        super.writeCharacters(NEWLINE);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(prefix, localName, namespaceURI);
    }

    private void onStartElement() throws XMLStreamException {
        this.stateStack.push(State.SEEN_ELEMENT);
        this.state = State.SEEN_NOTHING;
        if (this.depth > 0) {
            super.writeCharacters(NEWLINE);
        }
        this.doIndent();
        ++this.depth;
    }

    private void doIndent() throws XMLStreamException {
        for (int i = 0; i < this.depth; ++i) {
            super.writeCharacters(INDENTATION);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(localName);
    }

    private void onEmptyElement() throws XMLStreamException {
        this.state = State.SEEN_ELEMENT;
        if (this.depth > 0) {
            super.writeCharacters(NEWLINE);
        }
        this.doIndent();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        super.writeEndElement();
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (this.state == State.SEEN_ELEMENT) {
            super.writeCharacters(NEWLINE);
            this.doIndent();
        }
        this.state = this.stateStack.isEmpty() ? null : this.stateStack.pop();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.state = State.SEEN_DATA;
        super.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.state = State.SEEN_DATA;
        super.writeCharacters(text, start, len);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.state = State.SEEN_DATA;
        super.writeCData(data);
    }

    private static enum State {
        SEEN_NOTHING,
        SEEN_ELEMENT,
        SEEN_DATA;

    }
}

