/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.exporter.specobject;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.Newline;
import org.itsallcode.openfasttrace.api.core.SpecificationItem;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.exporter.Exporter;
import org.itsallcode.openfasttrace.api.exporter.ExporterException;

class SpecobjectExporter
implements Exporter {
    private static final Logger LOG = Logger.getLogger(SpecobjectExporter.class.getName());
    private final XMLStreamWriter writer;
    private final Writer originalWriter;
    private final Map<String, List<SpecificationItem>> items;
    private final Newline newline;

    public SpecobjectExporter(Stream<SpecificationItem> itemStream, XMLStreamWriter xmlWriter, Writer originalWriter, Newline newline) {
        this.newline = newline;
        this.items = this.groupByDoctype(itemStream);
        this.writer = xmlWriter;
        this.originalWriter = originalWriter;
    }

    private Map<String, List<SpecificationItem>> groupByDoctype(Stream<SpecificationItem> itemStream) {
        return itemStream.collect(Collectors.groupingBy(SpecificationItem::getArtifactType, LinkedHashMap::new, Collectors.toList()));
    }

    public void runExport() {
        try {
            this.writeOutput();
        }
        catch (XMLStreamException e) {
            throw new ExporterException("Error exporting to specobject format", (Throwable)e);
        }
        finally {
            this.closeXmlWriter();
        }
    }

    private void closeXmlWriter() {
        try {
            LOG.finest(() -> "Closing xml writer");
            this.writer.close();
            this.originalWriter.close();
        }
        catch (IOException | XMLStreamException e) {
            throw new ExporterException("Error closing writer", (Throwable)e);
        }
    }

    private void writeOutput() throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("specdocument");
        for (Map.Entry<String, List<SpecificationItem>> entry : this.items.entrySet()) {
            String doctype = entry.getKey();
            List<SpecificationItem> specItems = entry.getValue();
            this.writeItems(doctype, specItems);
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
    }

    private void writeItems(String doctype, List<SpecificationItem> specItems) throws XMLStreamException {
        LOG.finest(() -> "Writing " + specItems.size() + " items with doctype " + doctype);
        this.writer.writeStartElement("specobjects");
        this.writer.writeAttribute("doctype", doctype);
        for (SpecificationItem item : specItems) {
            this.writeItem(item);
        }
        this.writer.writeEndElement();
    }

    private void writeItem(SpecificationItem item) throws XMLStreamException {
        String description = this.processMultilineText(item.getDescription());
        String rationale = this.processMultilineText(item.getRationale());
        String comment = this.processMultilineText(item.getComment());
        this.writer.writeStartElement("specobject");
        this.writeElement("id", item.getName());
        this.writeElementIfPresent("shortdesc", item.getTitle());
        this.writeElement("status", item.getStatus().toString());
        this.writeElement("version", item.getRevision());
        this.writeLocation(item.getLocation());
        this.writeElementIfPresent("description", description);
        this.writeElementIfPresent("rationale", rationale);
        this.writeElementIfPresent("comment", comment);
        this.writeTags(item.getTags());
        this.writeNeedsArtifactTypes(item.getNeedsArtifactTypes());
        this.writeCoveredIds(item.getCoveredIds());
        this.writeDependsOnIds(item.getDependOnIds());
        this.writer.writeEndElement();
    }

    private String processMultilineText(String text) {
        return this.unifyNewlines(text);
    }

    private String unifyNewlines(String text) {
        Matcher matcher = Newline.anyNewlinePattern().matcher(text);
        return matcher.replaceAll(this.newline.toString());
    }

    private void writeTags(List<String> tags) throws XMLStreamException {
        if (tags.isEmpty()) {
            return;
        }
        this.writer.writeStartElement("tags");
        for (String tag : tags) {
            this.writeElement("tag", tag);
        }
        this.writer.writeEndElement();
    }

    private void writeDependsOnIds(List<SpecificationItemId> dependOnIds) throws XMLStreamException {
        if (dependOnIds.isEmpty()) {
            return;
        }
        this.writer.writeStartElement("dependencies");
        for (SpecificationItemId dependsOnId : dependOnIds) {
            this.writeElement("dependson", dependsOnId.toString());
        }
        this.writer.writeEndElement();
    }

    private void writeCoveredIds(List<SpecificationItemId> coveredIds) throws XMLStreamException {
        if (coveredIds.isEmpty()) {
            return;
        }
        this.writer.writeStartElement("providescoverage");
        for (SpecificationItemId coveredId : coveredIds) {
            this.writer.writeStartElement("provcov");
            this.writeElement("linksto", coveredId.getArtifactType() + ":" + coveredId.getName());
            this.writeElement("dstversion", coveredId.getRevision());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private void writeNeedsArtifactTypes(List<String> needsArtifactTypes) throws XMLStreamException {
        if (needsArtifactTypes.isEmpty()) {
            return;
        }
        this.writer.writeStartElement("needscoverage");
        for (String neededArtifactType : needsArtifactTypes) {
            this.writeElement("needsobj", neededArtifactType);
        }
        this.writer.writeEndElement();
    }

    private void writeElement(String elementName, int content) throws XMLStreamException {
        this.writeElement(elementName, String.valueOf(content));
    }

    private void writeElementIfPresent(String elementName, String content) throws XMLStreamException {
        if (content != null && !content.isEmpty()) {
            this.writeElement(elementName, content);
        }
    }

    private void writeElement(String elementName, String content) throws XMLStreamException {
        this.writer.writeStartElement(elementName);
        this.writer.writeCharacters(content);
        this.writer.writeEndElement();
    }

    private void writeLocation(Location location) throws XMLStreamException {
        if (location != null && location.getPath() != null && !location.getPath().isEmpty()) {
            this.writeElement("sourcefile", location.getPath());
            this.writeElement("sourceline", location.getLine());
        }
    }
}

