/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.lightweightmarkup;

import org.itsallcode.openfasttrace.api.core.ItemStatus;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.api.importer.Importer;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.ForwardingSpecificationItem;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.linereader.LineContext;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.linereader.LineReader;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.linereader.LineReaderCallback;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.LineParserState;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.LineParserStateMachine;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.LinePattern;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.Transition;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.TransitionAction;

public abstract class LightWeightMarkupImporter
implements Importer,
LineReaderCallback {
    protected final InputFile file;
    protected final ImportEventListener listener;
    protected final LineParserStateMachine stateMachine;
    private String lastTitle;
    private boolean inSpecificationItem;
    private LineContext currentContext;

    protected LightWeightMarkupImporter(InputFile file, ImportEventListener listener) {
        this.file = file;
        this.listener = listener;
        this.stateMachine = new LineParserStateMachine(this.configureTransitions());
    }

    public void runImport() {
        new LineReader(this.file, this).readFile();
    }

    protected abstract Transition[] configureTransitions();

    @Override
    public void nextLine(LineContext context) {
        this.currentContext = context;
        this.stateMachine.step(this.currentContext.currentLine(), this.currentContext.nextLine());
    }

    protected static Transition transition(LineParserState from, LineParserState to, LinePattern pattern, TransitionAction action) {
        return new Transition(from, to, pattern, action);
    }

    @Override
    public void finishReading() {
        if (this.inSpecificationItem) {
            this.listener.endSpecificationItem();
        }
    }

    protected void beginItem() {
        this.cleanUpLastItem();
        this.inSpecificationItem = true;
        this.informListenerAboutNewItem();
    }

    protected void cleanUpLastItem() {
        if (this.inSpecificationItem) {
            this.endItem();
        }
    }

    protected void informListenerAboutNewItem() {
        String idText = this.stateMachine.getLastToken();
        SpecificationItemId id = new SpecificationItemId.Builder(idText).build();
        this.listener.beginSpecificationItem();
        this.listener.setId(id);
        this.listener.setLocation(this.file.getPath(), this.currentContext.lineNumber());
        if (this.lastTitle != null) {
            this.listener.setTitle(this.lastTitle);
        }
    }

    protected void endItem() {
        this.inSpecificationItem = false;
        this.resetTitle();
        this.listener.endSpecificationItem();
    }

    protected void setStatus() {
        this.listener.setStatus(ItemStatus.parseString((String)this.stateMachine.getLastToken()));
    }

    protected void beginDescription() {
        this.listener.appendDescription(this.stateMachine.getLastToken());
    }

    protected void appendDescription() {
        this.listener.appendDescription(System.lineSeparator());
        this.listener.appendDescription(this.stateMachine.getLastToken());
    }

    protected void beginRationale() {
        this.listener.appendRationale(System.lineSeparator());
    }

    protected void appendRationale() {
        this.listener.appendRationale(System.lineSeparator());
        this.listener.appendRationale(this.stateMachine.getLastToken());
    }

    protected void beginComment() {
        this.listener.appendComment(this.stateMachine.getLastToken());
    }

    protected void appendComment() {
        this.listener.appendComment(System.lineSeparator());
        this.listener.appendComment(this.stateMachine.getLastToken());
    }

    protected void addDependency() {
        SpecificationItemId.Builder builder = new SpecificationItemId.Builder(this.stateMachine.getLastToken());
        this.listener.addDependsOnId(builder.build());
    }

    protected void addNeeds() {
        String artifactTypes = this.stateMachine.getLastToken();
        for (String artifactType : artifactTypes.split(",")) {
            this.listener.addNeededArtifactType(artifactType.trim());
        }
    }

    protected void rememberTitle() {
        this.lastTitle = this.stateMachine.getLastToken();
    }

    protected void resetTitle() {
        this.lastTitle = null;
    }

    protected void addCoverage() {
        this.listener.addCoveredId(SpecificationItemId.parseId((String)this.stateMachine.getLastToken()));
    }

    protected void addTag() {
        String tags = this.stateMachine.getLastToken();
        for (String tag : tags.split(",")) {
            this.listener.addTag(tag.trim());
        }
    }

    protected void forward() {
        ForwardingSpecificationItem forward = new ForwardingSpecificationItem(this.stateMachine.getLastToken());
        this.listener.beginSpecificationItem();
        this.listener.setId(forward.getSkippedId());
        this.listener.addCoveredId(forward.getOriginalId());
        for (String targetArtifactType : forward.getTargetArtifactTypes()) {
            this.listener.addNeededArtifactType(targetArtifactType.trim());
        }
        this.listener.setForwards(true);
        this.listener.setLocation(this.file.getPath(), this.currentContext.lineNumber());
        this.listener.endSpecificationItem();
    }
}

