/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.LineParserState;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.Transition;

public class LineParserStateMachine {
    private static final Logger LOG = Logger.getLogger(LineParserStateMachine.class.getName());
    private LineParserState state = LineParserState.START;
    private String lastToken = "";
    private final Transition[] transitions;

    public LineParserStateMachine(Transition[] transitions) {
        this.transitions = Arrays.copyOf(transitions, transitions.length);
    }

    public void step(String line, String nextLine) {
        boolean matched = false;
        for (Transition entry : this.transitions) {
            if (this.state != entry.getFrom() || !this.matchToken(line, nextLine, entry)) continue;
            LOG.finest(() -> entry + " : '" + line + "'");
            entry.getTransitionAction().transit();
            this.state = entry.getTo();
            matched = true;
            break;
        }
        if (!matched) {
            LOG.finest(() -> "Current state: " + this.state + ", no match for '" + line + "'");
        }
    }

    private boolean matchToken(String line, String nextLine, Transition entry) {
        Optional<List<String>> matches = entry.getLinePattern().getMatches(line, nextLine);
        if (matches.isPresent()) {
            List<String> groups = matches.get();
            this.lastToken = groups.isEmpty() ? "" : groups.get(0);
            return true;
        }
        this.lastToken = "";
        return false;
    }

    public String getLastToken() {
        return this.lastToken;
    }

    LineParserState getState() {
        return this.state;
    }
}

