/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.markdown;

import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.LinePattern;
import org.itsallcode.openfasttrace.importer.lightweightmarkup.statemachine.SimpleLinePattern;

enum MdPattern {
    COMMENT("Comment:\\s*"),
    COVERS("Covers:\\s*"),
    COVERS_REF(PatternConstants.REFERENCE_AFTER_BULLET),
    DEPENDS("Depends:\\s*"),
    DEPENDS_REF(PatternConstants.REFERENCE_AFTER_BULLET),
    DESCRIPTION("Description:\\s*"),
    EMPTY("(\\s*)"),
    EVERYTHING("(.*)"),
    FORWARD(".*?([a-zA-Z]+\\s*-->\\s*[a-zA-Z]+(?:,\\s*[a-zA-Z]+)*\\s*:\\s*" + SpecificationItemId.ID_PATTERN + ").*?"),
    ID("`?(" + SpecificationItemId.ID_PATTERN + ")`?.*"),
    NEEDS_INT("Needs:(\\s*\\w+\\s*(?:,\\s*\\w+\\s*)*)"),
    NEEDS("Needs:\\s*"),
    NEEDS_REF("\\s{0,3}[+*-](?:.*\\W)?(\\p{Alpha}+)(?:\\W.*)?"),
    NOT_EMPTY("([^\n\r]+)"),
    RATIONALE("Rationale:\\s*"),
    STATUS("Status:\\s*(approved|proposed|draft)\\s*"),
    TAGS_INT("Tags:(\\s*\\w+\\s*(?:,\\s*\\w+\\s*)*)"),
    TAGS("Tags:\\s*"),
    TAG_ENTRY("\\s{0,3}[+*-]\\s*(.*)"),
    TITLE("#+\\s*(.*)"),
    UNDERLINE("([=-]{3,})\\s*");

    private final LinePattern pattern;

    private MdPattern(String regularExpression) {
        this.pattern = SimpleLinePattern.of((String)regularExpression);
    }

    public LinePattern getPattern() {
        return this.pattern;
    }

    private static final class PatternConstants {
        public static final String ARTIFACT_TYPE = "[a-zA-Z]+";
        public static final String BULLETS = "[+*-]";
        private static final String UP_TO_3_WHITESPACES = "\\s{0,3}";
        public static final String REFERENCE_AFTER_BULLET = "\\s{0,3}[+*-](?:.*\\W)?(" + SpecificationItemId.ID_PATTERN + ")(?:\\W.*)?";

        private PatternConstants() {
        }
    }
}

