/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.specobject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.api.importer.Importer;
import org.itsallcode.openfasttrace.api.importer.ImporterException;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.importer.specobject.handler.SpecDocumentHandlerBuilder;
import org.itsallcode.openfasttrace.importer.xmlparser.XmlParserFactory;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeContentHandler;

class SpecobjectImporter
implements Importer {
    private final ImportEventListener listener;
    private final InputFile file;
    private final XmlParserFactory xmlParserFactory;

    SpecobjectImporter(InputFile file, XmlParserFactory xmlParserFactory, ImportEventListener listener) {
        this.file = file;
        this.xmlParserFactory = xmlParserFactory;
        this.listener = listener;
    }

    public void runImport() {
        try (BufferedReader reader = this.file.createReader();){
            SpecDocumentHandlerBuilder config = new SpecDocumentHandlerBuilder(this.file, this.listener);
            TreeContentHandler treeContentHandler = config.build();
            this.xmlParserFactory.createParser().parse(this.file.getPath(), (Reader)reader, treeContentHandler);
        }
        catch (IOException exception) {
            throw new ImporterException("Failed to read input file '" + this.file.getPath() + "': " + exception.getMessage(), (Throwable)exception);
        }
    }
}

