/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.specobject.handler;

import org.itsallcode.openfasttrace.api.core.ItemStatus;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.importer.specobject.handler.DependenciesHandlerBuilder;
import org.itsallcode.openfasttrace.importer.specobject.handler.FulfilledByHandlerBuilder;
import org.itsallcode.openfasttrace.importer.specobject.handler.NeedsCoverageHandlerBuilder;
import org.itsallcode.openfasttrace.importer.specobject.handler.ProvidesCoverageHandlerBuilder;
import org.itsallcode.openfasttrace.importer.specobject.handler.TagsHandlerBuilder;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.CallbackContentHandler;

class SingleSpecObjectsHandlerBuilder {
    private final CallbackContentHandler handler;
    private final ImportEventListener listener;
    private final SpecificationItemId.Builder idBuilder;
    private final Location.Builder locationBuilder;
    private String containedFileName = null;
    private int containedLine = -1;

    SingleSpecObjectsHandlerBuilder(ImportEventListener listener, SpecificationItemId.Builder idBuilder, Location.Builder locationBuilder) {
        this.listener = listener;
        this.idBuilder = idBuilder;
        this.locationBuilder = locationBuilder;
        this.handler = new CallbackContentHandler();
    }

    CallbackContentHandler build() {
        this.configureDataHandlers();
        this.configureSubTreeHanlders();
        this.ignoreCharacterData("creationdate", "source");
        return this.handler;
    }

    private void configureSubTreeHanlders() {
        this.handler.addSubTreeHandler("needscoverage", new NeedsCoverageHandlerBuilder(this.listener)::build).addSubTreeHandler("providescoverage", new ProvidesCoverageHandlerBuilder(this.listener)::build).addSubTreeHandler("dependencies", new DependenciesHandlerBuilder(this.listener)::build).addSubTreeHandler("fulfilledby", new FulfilledByHandlerBuilder()::build).addSubTreeHandler("tags", new TagsHandlerBuilder(this.listener)::build);
    }

    private void configureDataHandlers() {
        this.handler.addCharacterDataListener("id", this::removeArtifactTypeFromName).addIntDataListener("version", arg_0 -> ((SpecificationItemId.Builder)this.idBuilder).revision(arg_0)).addCharacterDataListener("description", arg_0 -> ((ImportEventListener)this.listener).appendDescription(arg_0)).addCharacterDataListener("rationale", arg_0 -> ((ImportEventListener)this.listener).appendRationale(arg_0)).addCharacterDataListener("comment", arg_0 -> ((ImportEventListener)this.listener).appendComment(arg_0)).addCharacterDataListener("status", this::setStatus).addCharacterDataListener("shortdesc", arg_0 -> ((ImportEventListener)this.listener).setTitle(arg_0)).addCharacterDataListener("sourcefile", this::rememberSourceFile).addIntDataListener("sourceline", this::rememberSourceLine);
    }

    private void setStatus(String statusAsText) {
        this.listener.setStatus(ItemStatus.parseString((String)statusAsText));
    }

    private void removeArtifactTypeFromName(String data) {
        this.idBuilder.name(data);
    }

    private void ignoreCharacterData(String ... elements) {
        for (String element : elements) {
            this.handler.addCharacterDataListener(element, text -> {});
        }
    }

    private void rememberSourceFile(String fileName) {
        this.containedFileName = fileName;
        this.setContainedLocationIfComplete();
    }

    private void rememberSourceLine(int line) {
        this.containedLine = line;
        this.setContainedLocationIfComplete();
    }

    private void setContainedLocationIfComplete() {
        if (this.containedFileName != null && this.containedLine >= 1) {
            this.locationBuilder.path(this.containedFileName).line(this.containedLine);
        }
    }
}

