/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.specobject.handler;

import java.util.logging.Logger;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.api.importer.ImporterException;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.importer.specobject.handler.SpecObjectsHandlerBuilder;
import org.itsallcode.openfasttrace.importer.xmlparser.event.Attribute;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.CallbackContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeContentHandler;

public class SpecDocumentHandlerBuilder {
    private static final Logger LOG = Logger.getLogger(SpecDocumentHandlerBuilder.class.getName());
    private static final String DOCTYPE_ATTRIBUTE_NAME = "doctype";
    private final CallbackContentHandler handler;
    private final InputFile file;
    private final ImportEventListener listener;

    public SpecDocumentHandlerBuilder(InputFile file, ImportEventListener listener) {
        this.file = file;
        this.listener = listener;
        this.handler = new CallbackContentHandler();
    }

    public TreeContentHandler build() {
        this.handler.setDefaultStartElementListener(startElement -> {
            if (startElement.isRootElement()) {
                LOG.fine(() -> "Found unknown root element '" + startElement + "': skip file");
                this.handler.stopParsing();
            }
            LOG.warning(() -> "Found unknown element " + startElement);
        });
        this.handler.addElementListener("specdocument", elem -> {
            LOG.finest(() -> "Found specdocument element " + elem);
            if (!elem.isRootElement()) {
                throw new IllegalStateException("Element specdocument must be root element");
            }
        });
        this.handler.addElementListener("specobjects", elem -> {
            Attribute doctypeAttribute = elem.getAttributeValueByName(DOCTYPE_ATTRIBUTE_NAME);
            if (doctypeAttribute == null) {
                throw new ImporterException("Element " + elem + " does not have an attribute 'doctype' at " + elem.getLocation());
            }
            String defaultDoctype = doctypeAttribute.getValue();
            this.handler.pushDelegate((TreeContentHandler)new SpecObjectsHandlerBuilder(this.file, defaultDoctype, this.listener).build());
        });
        return this.handler;
    }
}

