/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.specobject.handler;

import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.importer.specobject.handler.SingleSpecObjectsHandlerBuilder;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.CallbackContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeElement;

class SpecObjectsHandlerBuilder {
    private final CallbackContentHandler handler;
    private final InputFile file;
    private final ImportEventListener listener;
    private SpecificationItemId.Builder idBuilder = new SpecificationItemId.Builder();
    private final String defaultDoctype;
    private Location.Builder locationBuilder;

    SpecObjectsHandlerBuilder(InputFile file, String defaultDoctype, ImportEventListener listener) {
        this.file = file;
        this.defaultDoctype = defaultDoctype;
        this.listener = listener;
        this.handler = new CallbackContentHandler();
    }

    CallbackContentHandler build() {
        this.handler.addElementListener("specobject", this::handleStartElement, endElement -> this.handleEndElement());
        return this.handler;
    }

    private void handleStartElement(TreeElement elem) {
        this.listener.beginSpecificationItem();
        this.locationBuilder = Location.builder().path(this.file.getPath()).line(elem.getLocation().getLine());
        this.idBuilder = new SpecificationItemId.Builder().artifactType(this.defaultDoctype);
        this.handler.pushDelegate((TreeContentHandler)new SingleSpecObjectsHandlerBuilder(this.listener, this.idBuilder, this.locationBuilder).build());
    }

    private void handleEndElement() {
        this.listener.setId(this.idBuilder.build());
        this.listener.setLocation(this.locationBuilder.build());
        this.listener.endSpecificationItem();
        this.idBuilder = null;
        this.locationBuilder = null;
    }
}

