/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.itsallcode.openfasttrace.importer.xmlparser.XmlParser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlParserFactory {
    private final SAXParserFactory parserFactory = XmlParserFactory.createSaxParserFactory();

    public XmlParser createParser() {
        return new XmlParser(this.parserFactory);
    }

    private static SAXParserFactory createSaxParserFactory() {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        try {
            parserFactory.setNamespaceAware(true);
            XmlParserFactory.forbidDoctypeDeclaration(parserFactory);
            XmlParserFactory.enableSecureProcessing(parserFactory);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException("Error configuring sax parser factory", e);
        }
        return parserFactory;
    }

    private static void enableSecureProcessing(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    private static void forbidDoctypeDeclaration(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    }
}

