/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser.tree;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.itsallcode.openfasttrace.importer.xmlparser.ContentHandlerAdapterController;
import org.itsallcode.openfasttrace.importer.xmlparser.EventContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.event.EndElementEvent;
import org.itsallcode.openfasttrace.importer.xmlparser.event.StartElementEvent;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeElement;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeParsingController;

public class TreeBuildingContentHandler
implements EventContentHandler,
TreeParsingController {
    private final Deque<TreeElement> stack = new ArrayDeque<TreeElement>();
    private TreeContentHandler delegate;
    private ContentHandlerAdapterController contentHandlerAdapter;

    public TreeBuildingContentHandler(TreeContentHandler delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public void init(ContentHandlerAdapterController contentHandlerAdapter) {
        this.contentHandlerAdapter = contentHandlerAdapter;
        this.delegate.init(this);
    }

    @Override
    public void startElement(StartElementEvent event) {
        TreeElement parent = this.stack.peek();
        TreeElement treeElement = new TreeElement(event, parent);
        this.stack.push(treeElement);
        this.delegate.startElement(treeElement);
    }

    @Override
    public void endElement(EndElementEvent event) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Got closing event " + event + " but stack is empty");
        }
        TreeElement topElement = this.stack.peek();
        if (!topElement.getElement().getName().equals(event.getName())) {
            throw new IllegalStateException("Top stack element is " + topElement.getElement() + " but got end event for " + event);
        }
        TreeElement closedElement = this.stack.pop();
        this.delegate.endElement(closedElement);
    }

    @Override
    public void characters(String characters) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Got characters '" + characters + "' but stack is empty");
        }
        this.stack.peek().addCharacterData(characters);
    }

    @Override
    public void setDelegate(TreeContentHandler newDelegate) {
        this.delegate = Objects.requireNonNull(newDelegate, "newDelegate");
        newDelegate.init(this);
    }

    @Override
    public TreeElement getCurrentElement() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Stack is empty");
        }
        return this.stack.peek();
    }

    @Override
    public void stopParsing() {
        this.contentHandlerAdapter.parsingFinished();
    }
}

