/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.aspec;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.itsallcode.openfasttrace.api.core.DeepCoverageStatus;
import org.itsallcode.openfasttrace.api.core.LinkStatus;
import org.itsallcode.openfasttrace.api.core.LinkedSpecificationItem;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.api.core.Newline;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.core.Trace;
import org.itsallcode.openfasttrace.api.exporter.ExporterException;
import org.itsallcode.openfasttrace.api.report.Reportable;
import org.itsallcode.openfasttrace.api.report.ReporterContext;
import org.itsallcode.openfasttrace.exporter.common.IndentingXMLStreamWriter;

class ASpecReport
implements Reportable {
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_COVERING_STATUS = "coveringStatus";
    private static final String VALUE_UNCOVERED = "UNCOVERED";
    private static final String VALUE_COVERED = "COVERED";
    private static final String ATTRIBUTE_DOCTYPE = "doctype";
    private static final Logger LOG = Logger.getLogger(ASpecReport.class.getName());
    private final Trace trace;
    private final XMLOutputFactory xmlOutputFactory;
    private final Newline newline;

    ASpecReport(Trace trace, ReporterContext context) {
        this.trace = trace;
        this.newline = context.getSettings().getNewline();
        this.xmlOutputFactory = XMLOutputFactory.newFactory();
    }

    public void renderToStream(OutputStream outputStream) {
        XMLStreamWriter xmlWriter = this.createXmlWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        IndentingXMLStreamWriter indentingXmlWriter = new IndentingXMLStreamWriter(xmlWriter);
        LOG.fine("aspec starting");
        try (IndentingXMLStreamWriter indentingXMLStreamWriter = indentingXmlWriter;){
            this.writeOutput((XMLStreamWriter)indentingXmlWriter);
        }
        catch (XMLStreamException exception) {
            throw new ExporterException("Generating document", (Throwable)exception);
        }
    }

    private XMLStreamWriter createXmlWriter(Writer writer) {
        try {
            return this.xmlOutputFactory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException exception) {
            throw new ExporterException("Error creating XML stream writer for writer " + writer, (Throwable)exception);
        }
    }

    private void writeOutput(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        this.writeSpecDocument(writer);
        writer.writeEndDocument();
    }

    private void writeSpecDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("specdocument");
        for (Map.Entry<String, List<LinkedSpecificationItem>> entry : this.groupItemsByAttributeType(this.trace.getItems()).entrySet()) {
            String doctype = entry.getKey();
            List<LinkedSpecificationItem> specItems = entry.getValue();
            this.writeItems(writer, doctype, specItems);
        }
        writer.writeEndElement();
    }

    private Map<String, List<LinkedSpecificationItem>> groupItemsByAttributeType(List<LinkedSpecificationItem> items) {
        return items.stream().collect(Collectors.groupingBy(LinkedSpecificationItem::getArtifactType, LinkedHashMap::new, Collectors.toList()));
    }

    private void writeItems(XMLStreamWriter writer, String doctype, List<LinkedSpecificationItem> specItems) throws XMLStreamException {
        LOG.finest(() -> "Writing " + specItems.size() + " items with doctype " + doctype);
        writer.writeStartElement("specobjects");
        writer.writeAttribute(ATTRIBUTE_DOCTYPE, doctype);
        for (LinkedSpecificationItem item : specItems) {
            this.writeItem(writer, item);
        }
        writer.writeEndElement();
    }

    private void writeItem(XMLStreamWriter writer, LinkedSpecificationItem item) throws XMLStreamException {
        writer.writeStartElement("specobject");
        this.writeItemValues(writer, item);
        this.writeItemCoverage(writer, item);
        this.writeCoveredIds(writer, item.getCoveredIds());
        this.writeDependsOnIds(writer, item.getItem().getDependOnIds());
        writer.writeEndElement();
    }

    private void writeItemValues(XMLStreamWriter writer, LinkedSpecificationItem item) throws XMLStreamException {
        String description = this.processMultilineText(item.getDescription());
        String rationale = this.processMultilineText(item.getItem().getRationale());
        String comment = this.processMultilineText(item.getItem().getComment());
        this.writeElement(writer, "id", item.getName());
        this.writeElement(writer, ELEMENT_VERSION, item.getRevision());
        this.writeElementIfPresent(writer, "shortdesc", item.getTitle());
        this.writeElement(writer, "status", item.getStatus().toString());
        this.writeLocation(writer, item.getLocation());
        this.writeElementIfPresent(writer, "description", description);
        this.writeElementIfPresent(writer, "rationale", rationale);
        this.writeElementIfPresent(writer, "comment", comment);
        this.writeTags(writer, item.getTags());
    }

    private String processMultilineText(String text) {
        return this.unifyNewlines(text);
    }

    private String unifyNewlines(String text) {
        Matcher matcher = Newline.anyNewlinePattern().matcher(text);
        return matcher.replaceAll(this.newline.toString());
    }

    private void writeTags(XMLStreamWriter writer, List<String> tags) throws XMLStreamException {
        if (tags.isEmpty()) {
            return;
        }
        writer.writeStartElement("tags");
        for (String tag : tags) {
            this.writeElement(writer, "tag", tag);
        }
        writer.writeEndElement();
    }

    private void writeItemCoverage(XMLStreamWriter writer, LinkedSpecificationItem item) throws XMLStreamException {
        writer.writeStartElement("coverage");
        this.writeNeedsArtifactTypes(writer, item.getNeedsArtifactTypes());
        this.writeElement(writer, "shallowCoverageStatus", item.isCoveredShallowWithApprovedItems() ? VALUE_COVERED : VALUE_UNCOVERED);
        this.writeElement(writer, "deepCoverageStatus", item.getDeepCoverageStatusOnlyAcceptApprovedItems().name());
        this.writeCoveringSpecObjects(writer, item);
        this.writeCoveredTypes(writer, item.getCoveredApprovedArtifactTypes());
        this.writeUncoveredTypes(writer, item.getUncoveredApprovedArtifactTypes());
        writer.writeEndElement();
    }

    private void writeCoveringSpecObjects(XMLStreamWriter writer, LinkedSpecificationItem item) throws XMLStreamException {
        writer.writeStartElement("coveringSpecObjects");
        for (Map.Entry entry2 : item.getLinks().entrySet().stream().filter(entry -> ((LinkStatus)entry.getKey()).isIncoming()).collect(Collectors.toCollection(LinkedList::new))) {
            for (LinkedSpecificationItem coveringItem : (List)entry2.getValue()) {
                this.writeCoveringSpecObject(writer, (LinkStatus)entry2.getKey(), coveringItem);
            }
        }
        writer.writeEndElement();
    }

    private void writeCoveringSpecObject(XMLStreamWriter writer, LinkStatus linkStatus, LinkedSpecificationItem item) throws XMLStreamException {
        writer.writeStartElement("coveringSpecObject");
        this.writeElement(writer, "id", item.getName());
        this.writeElement(writer, ELEMENT_VERSION, item.getRevision());
        this.writeElement(writer, ATTRIBUTE_DOCTYPE, item.getArtifactType());
        this.writeElement(writer, "status", item.getStatus().toString());
        this.writeElement(writer, "ownCoverageStatus", item.isCoveredShallowWithApprovedItems() ? VALUE_COVERED : VALUE_UNCOVERED);
        DeepCoverageStatus deepCoverageStatus = item.getDeepCoverageStatusOnlyAcceptApprovedItems();
        this.writeElement(writer, "deepCoverageStatus", deepCoverageStatus == DeepCoverageStatus.COVERED ? VALUE_COVERED : deepCoverageStatus.name());
        this.writeCoveringStatus(writer, linkStatus, deepCoverageStatus);
        writer.writeEndElement();
    }

    private void writeCoveringStatus(XMLStreamWriter writer, LinkStatus linkStatus, DeepCoverageStatus deepCoverageStatus) throws XMLStreamException {
        if (linkStatus == LinkStatus.COVERED_SHALLOW && deepCoverageStatus == DeepCoverageStatus.COVERED) {
            this.writeElement(writer, ELEMENT_COVERING_STATUS, CoveringStatus.COVERING.getLabel());
        } else if (linkStatus == LinkStatus.COVERED_SHALLOW) {
            this.writeElement(writer, ELEMENT_COVERING_STATUS, CoveringStatus.UNCOVERED.getLabel());
        } else if (linkStatus == LinkStatus.COVERED_PREDATED || linkStatus == LinkStatus.COVERED_OUTDATED) {
            this.writeElement(writer, ELEMENT_COVERING_STATUS, CoveringStatus.OUTDATED.getLabel());
        } else if (linkStatus == LinkStatus.AMBIGUOUS || linkStatus == LinkStatus.COVERED_UNWANTED) {
            this.writeElement(writer, ELEMENT_COVERING_STATUS, CoveringStatus.UNEXPECTED.getLabel());
        }
    }

    private void writeDependsOnIds(XMLStreamWriter writer, List<SpecificationItemId> dependOnIds) throws XMLStreamException {
        if (dependOnIds.isEmpty()) {
            return;
        }
        writer.writeStartElement("dependencies");
        for (SpecificationItemId dependsOnId : dependOnIds) {
            writer.writeStartElement("dependsOnSpecObject");
            this.writeElement(writer, "id", dependsOnId.getName());
            this.writeElement(writer, ELEMENT_VERSION, dependsOnId.getRevision());
            this.writeElement(writer, ATTRIBUTE_DOCTYPE, dependsOnId.getArtifactType());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeCoveredIds(XMLStreamWriter writer, List<SpecificationItemId> coveredIds) throws XMLStreamException {
        if (coveredIds.isEmpty()) {
            return;
        }
        writer.writeStartElement("covering");
        for (SpecificationItemId coveredId : coveredIds) {
            writer.writeStartElement("coveredType");
            this.writeElement(writer, "id", coveredId.getName());
            this.writeElement(writer, ELEMENT_VERSION, coveredId.getRevision());
            this.writeElement(writer, ATTRIBUTE_DOCTYPE, coveredId.getArtifactType());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeNeedsArtifactTypes(XMLStreamWriter writer, List<String> needsArtifactTypes) throws XMLStreamException {
        if (needsArtifactTypes.isEmpty()) {
            return;
        }
        writer.writeStartElement("needscoverage");
        for (String neededArtifactType : needsArtifactTypes) {
            this.writeElement(writer, "needsobj", neededArtifactType);
        }
        writer.writeEndElement();
    }

    private void writeCoveredTypes(XMLStreamWriter writer, Set<String> types) throws XMLStreamException {
        if (types.isEmpty()) {
            return;
        }
        writer.writeStartElement("coveredTypes");
        for (String type : types) {
            this.writeElement(writer, "coveredType", type);
        }
        writer.writeEndElement();
    }

    private void writeUncoveredTypes(XMLStreamWriter writer, List<String> types) throws XMLStreamException {
        if (types.isEmpty()) {
            return;
        }
        writer.writeStartElement("uncoveredTypes");
        for (String type : types) {
            this.writeElement(writer, "uncoveredType", type);
        }
        writer.writeEndElement();
    }

    private void writeElement(XMLStreamWriter writer, String elementName, int content) throws XMLStreamException {
        this.writeElement(writer, elementName, String.valueOf(content));
    }

    private void writeElementIfPresent(XMLStreamWriter writer, String elementName, String content) throws XMLStreamException {
        if (content != null && !content.isEmpty()) {
            this.writeElement(writer, elementName, content);
        }
    }

    private void writeElement(XMLStreamWriter writer, String elementName, String content) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeCharacters(content);
        writer.writeEndElement();
    }

    private void writeLocation(XMLStreamWriter writer, Location location) throws XMLStreamException {
        if (location != null && location.getPath() != null && !location.getPath().isEmpty()) {
            this.writeElement(writer, "sourcefile", location.getPath());
            this.writeElement(writer, "sourceline", location.getLine());
        }
    }

    public static enum CoveringStatus {
        COVERING("COVERING"),
        UNCOVERED("UNCOVERED"),
        OUTDATED("COVERING_WRONG_VERSION"),
        UNEXPECTED("UNEXPECTED");

        private final String label;

        private CoveringStatus(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

