/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html;

import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import org.itsallcode.openfasttrace.api.ReportSettings;
import org.itsallcode.openfasttrace.api.core.LinkedSpecificationItem;
import org.itsallcode.openfasttrace.api.core.Trace;
import org.itsallcode.openfasttrace.api.report.Reportable;
import org.itsallcode.openfasttrace.report.html.view.ViewFactory;
import org.itsallcode.openfasttrace.report.html.view.Viewable;
import org.itsallcode.openfasttrace.report.html.view.ViewableContainer;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlViewFactory;

public class HtmlReport
implements Reportable {
    private final Trace trace;
    private static final String REPORT_CSS_FILE = "/css/report.css";
    private final ReportSettings settings;

    public HtmlReport(Trace trace, ReportSettings settings) {
        this.trace = trace;
        this.settings = settings;
    }

    public static URL getCssUrl() {
        return HtmlReport.class.getResource(REPORT_CSS_FILE);
    }

    public void renderToStream(OutputStream outputStream) {
        HtmlViewFactory factory = HtmlViewFactory.create(outputStream, HtmlReport.getCssUrl(), this.settings.getDetailsSectionDisplay());
        ViewableContainer view = factory.createView("", "Specification items by artifact type");
        ViewableContainer details = this.createDetails(factory);
        ViewableContainer summary = this.createSummary(details, factory);
        view.add(details);
        view.add(summary);
        view.render();
    }

    private ViewableContainer createDetails(ViewFactory factory) {
        ViewableContainer details = factory.createReportDetails();
        List<LinkedSpecificationItem> items = this.getSortedItems();
        this.addSectionedItems(factory, details, items);
        return details;
    }

    private List<LinkedSpecificationItem> getSortedItems() {
        List items = this.trace.getItems();
        items.sort(Comparator.comparing(LinkedSpecificationItem::getArtifactType).thenComparing(LinkedSpecificationItem::getTitleWithFallback));
        return items;
    }

    private void addSectionedItems(ViewFactory factory, ViewableContainer view, List<LinkedSpecificationItem> items) {
        String artifactType = "\u0000";
        ViewableContainer section = factory.createSection(artifactType, artifactType);
        for (LinkedSpecificationItem item : items) {
            String currentArtifactType = item.getArtifactType();
            if (!artifactType.equals(currentArtifactType)) {
                artifactType = currentArtifactType;
                section = factory.createSection(artifactType, artifactType);
                view.add(section);
            }
            Viewable itemView = factory.createSpecificationItem(item);
            section.add(itemView);
        }
    }

    private ViewableContainer createSummary(ViewableContainer view, ViewFactory factory) {
        ViewableContainer summary = factory.createReportSummary();
        summary.add(factory.createTraceSummary(this.trace));
        summary.add(factory.createTableOfContents(view));
        return summary;
    }
}

