/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view;

import java.util.ArrayList;
import java.util.List;
import org.itsallcode.openfasttrace.report.html.view.Viewable;
import org.itsallcode.openfasttrace.report.html.view.ViewableContainer;

public abstract class AbstractViewContainer
implements ViewableContainer {
    private final List<Viewable> children;
    private final String id;
    private final String title;

    protected AbstractViewContainer() {
        this(null, null);
    }

    protected AbstractViewContainer(String id, String title) {
        this.id = id;
        this.title = title;
        this.children = new ArrayList<Viewable>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isReferenceable() {
        return this.id != null;
    }

    @Override
    public void render(int level) {
        this.renderBeforeChildren(level);
        this.renderChildren(level);
        this.renderAfterChildren(level);
    }

    protected abstract void renderBeforeChildren(int var1);

    protected void renderChildren(int level) {
        for (Viewable child : this.children) {
            child.render(level + 1);
        }
    }

    protected abstract void renderAfterChildren(int var1);

    @Override
    public void add(Viewable child) {
        this.children.add(child);
    }

    @Override
    public List<Viewable> getChildren() {
        return this.children;
    }
}

