/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.itsallcode.openfasttrace.api.DetailsSectionDisplay;
import org.itsallcode.openfasttrace.api.core.LinkStatus;
import org.itsallcode.openfasttrace.api.core.LinkedSpecificationItem;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.core.TracedLink;
import org.itsallcode.openfasttrace.report.html.view.IndentationHelper;
import org.itsallcode.openfasttrace.report.html.view.Viewable;
import org.itsallcode.openfasttrace.report.html.view.html.MarkdownConverter;
import org.itsallcode.openfasttrace.report.html.view.html.MarkdownSpanConverter;
import org.itsallcode.openfasttrace.report.html.view.html.OriginLinkFormatter;

class HtmlSpecificationItem
implements Viewable {
    private final LinkedSpecificationItem item;
    private final PrintStream stream;
    private final MarkdownConverter converter = new MarkdownConverter();
    private final DetailsSectionDisplay detailsDisplay;

    HtmlSpecificationItem(PrintStream stream, LinkedSpecificationItem item, DetailsSectionDisplay detailsDisplay) {
        this.stream = stream;
        this.item = item;
        this.detailsDisplay = detailsDisplay;
    }

    @Override
    public void render(int level) {
        String indentation = IndentationHelper.createIndentationPrefix(level);
        SpecificationItemId id = this.item.getId();
        this.renderStart(indentation, id);
        this.renderSummary(indentation, id);
        this.renderId(indentation, id);
        this.renderDescription(indentation);
        this.renderRationale(indentation);
        this.renderComment(indentation);
        this.renderNeeds(indentation);
        this.renderOrigin(indentation);
        this.renderLinks(indentation);
        this.renderEnd(indentation);
    }

    protected void renderStart(String indentation, SpecificationItemId id) {
        this.stream.print(indentation);
        this.stream.print("<section class=\"sitem\" id=\"");
        this.stream.print(id);
        this.stream.println("\">");
        this.stream.print(indentation);
        this.stream.println("  <details" + this.detailsAttributes() + ">");
    }

    private String detailsAttributes() {
        return this.detailsDisplay == DetailsSectionDisplay.EXPAND ? " open" : "";
    }

    private void renderId(String indentation, SpecificationItemId id) {
        this.stream.print(indentation);
        this.stream.print("    <p class=\"id\">");
        this.stream.print(id);
        this.stream.println("</p>");
    }

    protected void renderSummary(String indentation, SpecificationItemId id) {
        this.stream.print(indentation);
        this.stream.print("    <summary title=\"");
        this.stream.print(id);
        this.stream.print("\">");
        this.stream.print(this.item.isDefect() ? "<span class=\"red\">&cross;</span>" : "<span class=\"green\">&check;</span>");
        this.stream.print(" <b>");
        this.stream.print(this.escapedTitle());
        this.stream.print("</b><small>, rev. ");
        this.stream.print(id.getRevision());
        this.stream.print(", ");
        this.stream.print(id.getArtifactType());
        this.stream.println("</small></summary>");
    }

    private String escapedTitle() {
        return MarkdownSpanConverter.escapeHtml(this.item.getTitleWithFallback());
    }

    protected void renderDescription(String indentation) {
        String description = this.item.getDescription();
        if (description != null && !description.isEmpty()) {
            this.renderMultilineText(indentation, description);
        }
    }

    protected void renderMultilineText(String indentation, String text) {
        this.stream.print(indentation);
        this.stream.print("    ");
        this.stream.println(this.converter.convert(text));
    }

    private void renderRationale(String indentation) {
        String rationale = this.item.getItem().getRationale();
        if (rationale != null && !rationale.isEmpty()) {
            this.stream.print(indentation);
            this.stream.println("    <h6>Rationale:</h6>");
            this.renderMultilineText(indentation, rationale);
        }
    }

    private void renderComment(String indentation) {
        String comment = this.item.getItem().getComment();
        if (comment != null && !comment.isEmpty()) {
            this.stream.print(indentation);
            this.stream.println("    <h6>Comment:</h6>");
            this.renderMultilineText(indentation, comment);
        }
    }

    private void renderNeeds(String indentation) {
        if (this.item.getNeedsArtifactTypes() != null && !this.item.getNeedsArtifactTypes().isEmpty() || this.item.getUncoveredArtifactTypes() != null && !this.item.getUncoveredArtifactTypes().isEmpty() || this.item.getOverCoveredArtifactTypes() != null && !this.item.getOverCoveredArtifactTypes().isEmpty()) {
            this.stream.print(indentation);
            this.stream.print("    <h6>Needs: ");
            this.stream.print(this.translateArtifactTypeCoverage(this.item));
            this.stream.println("</h6>");
        }
    }

    private String translateArtifactTypeCoverage(LinkedSpecificationItem item) {
        Comparator<String> byTypeName = Comparator.comparing(a -> a.replaceFirst("<(?:ins|del)>", ""));
        Stream<String> uncoveredStream = item.getUncoveredArtifactTypes().stream().map(x -> "<ins>" + x + "</ins>");
        return Stream.concat(Stream.concat(uncoveredStream, item.getCoveredArtifactTypes().stream()), item.getOverCoveredArtifactTypes().stream().map(x -> "<del>" + x + "</del>")).sorted(byTypeName).collect(Collectors.joining(", "));
    }

    private void renderOrigin(String indentation) {
        String origin = OriginLinkFormatter.formatAsBlock(this.item.getLocation());
        if (!origin.isEmpty()) {
            this.stream.print(indentation);
            this.stream.print("    ");
            this.stream.println(origin);
        }
    }

    private void renderLinks(String indentation) {
        this.renderLinkForDirection(indentation, true);
        this.renderLinkForDirection(indentation, false);
    }

    protected void renderLinkForDirection(String indentation, boolean in) {
        int total;
        int n = total = in ? this.item.countIncomingLinks() : this.item.countOutgoingLinks();
        if (total > 0) {
            this.stream.print(indentation);
            this.stream.print("    <div class=\"");
            this.stream.print(in ? "in" : "out");
            this.stream.println("\">");
            this.stream.print(indentation);
            this.stream.print("      <h6>");
            this.stream.print(in ? "In" : "Out");
            this.stream.print(": ");
            this.stream.print(total);
            this.stream.println("</h6>");
            this.stream.print(indentation);
            this.stream.println("      <ul>");
            Stream<TracedLink> links = this.item.getTracedLinks().stream().filter(in ? TracedLink::isIncoming : TracedLink::isOutgoing);
            List<TracedLink> sortedLinks = this.sortLinkStreamById(links);
            this.renderLinkEntry(sortedLinks, indentation);
            this.stream.print(indentation);
            this.stream.println("      </ul>");
            this.stream.print(indentation);
            this.stream.println("    </div>");
        }
    }

    protected List<TracedLink> sortLinkStreamById(Stream<TracedLink> tracedLinkStream) {
        return tracedLinkStream.sorted(Comparator.comparing(a -> a.getOtherLinkEnd().getId().toString())).collect(Collectors.toList());
    }

    protected void renderLinkEntry(List<TracedLink> outLinks, String indentation) {
        for (TracedLink link : outLinks) {
            SpecificationItemId otherId = link.getOtherLinkEnd().getId();
            this.stream.print(indentation);
            this.stream.print("        <li><a href=\"#");
            this.stream.print(otherId);
            this.stream.print("\">");
            this.stream.print(otherId);
            this.stream.print("</a>");
            if (link.getStatus() != LinkStatus.COVERS && link.getStatus() != LinkStatus.COVERED_SHALLOW) {
                this.stream.print(" <em>(" + link.getStatus() + ")</em>");
            }
            this.renderLinkOrigin(link);
            this.stream.println("</li>");
        }
    }

    private void renderLinkOrigin(TracedLink link) {
        String origin = OriginLinkFormatter.formatAsSpan(link.getOtherLinkEnd().getLocation());
        if (!origin.isEmpty()) {
            this.stream.print(" ");
            this.stream.print(origin);
        }
    }

    protected void renderEnd(String indentation) {
        this.stream.print(indentation);
        this.stream.println("  </details>");
        this.stream.print(indentation);
        this.stream.println("</section>");
    }
}

