/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.io.PrintStream;
import org.itsallcode.openfasttrace.report.html.view.Viewable;
import org.itsallcode.openfasttrace.report.html.view.ViewableContainer;

class HtmlTableOfContents
implements Viewable {
    private final PrintStream stream;
    private final ViewableContainer from;

    HtmlTableOfContents(PrintStream outputStream, ViewableContainer from) {
        this.stream = outputStream;
        this.from = from;
    }

    @Override
    public void render(int level) {
        boolean first = true;
        for (Viewable view : this.from.getChildren()) {
            this.renderTableOfContentsItem(view, first);
            first = false;
        }
    }

    protected void renderTableOfContentsItem(Viewable view, boolean first) {
        if (view instanceof ViewableContainer) {
            this.renderContainerItem(view, first);
        }
    }

    protected void renderContainerItem(Viewable view, boolean first) {
        ViewableContainer container = (ViewableContainer)view;
        if (container.isReferenceable()) {
            this.renderSeparator(first);
            this.renderLinkWithText(container);
        }
    }

    protected void renderSeparator(boolean first) {
        this.stream.print(first ? " | " : " &middot; ");
    }

    protected void renderLinkWithText(ViewableContainer container) {
        this.stream.print("<a href=\"#");
        this.stream.print(container.getId());
        this.stream.print("\">");
        this.stream.print(container.getTitle());
        this.stream.print("</a>");
    }
}

